<div class="d-flex flex-column justify-content-lg-center p-4 p-lg-0 pb-0 flex-fill">
    <div class=" mx-auto mb-3 text-center">
        <img src="<?php echo e(asset('assets/img/PRED_CARE-Logo.png')); ?>" class="img-fluid login-logo-small" alt="Logo">
    </div>
    <div class="card border-1 p-lg-3 shadow-md rounded-3 mb-4">
        <div class="card-body">
            <div class="text-center mb-3">
                <h5 class="mb-1 fs-20 fw-bold">Admin <?php echo e($role === 'superadminstaff' ? 'Staff' : ''); ?> Sign In</h5>
                <p class="mb-0">Please enter below details to access the admin dashboard</p>
            </div>

            <!--[if BLOCK]><![endif]--><?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div><?php echo e($error); ?></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <div class="mb-3">
                <label class="form-label">Email Address</label>
                <div class="input-group">
                    <span class="input-group-text border-end-0 bg-white">
                        <i class="ti ti-mail fs-14 text-dark"></i>
                    </span>
                    <input wire:model="email" type="email" name="email" value="<?php echo e(old('email')); ?>"
                        class="form-control border-start-0 ps-0" placeholder="Enter Email Address" 
                        wire:keydown.enter="login" required>
                </div>
            </div>
            <div class="mb-3">
                <label class="form-label">Password</label>
                <div class="position-relative">
                    <div class="pass-group input-group position-relative border rounded">
                        <span class="input-group-text bg-white border-0">
                            <i class="ti ti-lock text-dark fs-14"></i>
                        </span>
                        <input wire:model="password" type="password" name="password"
                            class="pass-input form-control ps-0 border-0" placeholder="****************" 
                            wire:keydown.enter="login" required>
                        <span class="input-group-text bg-white border-0">
                            <i class="ti toggle-password ti-eye-off text-dark fs-14"></i>
                        </span>
                    </div>
                </div>
            </div>
            <div class="text-end my-2">
                <a href="<?php echo e(route('forgot-password')); ?>" class="text-danger">Forgot Password?</a>
            </div>
            <div class="mb-3">
                <button type="button"
                    class="btn bg-primary text-white w-100 position-relative d-flex align-items-center justify-content-center"
                    wire:click="login"
                    wire:loading.attr="disabled">

                    <span wire:loading.class="d-none">
                        <i class="fas fa-sign-in-alt me-2"></i>
                        Login
                    </span>

                    <span wire:loading.class.remove="d-none" class="d-none">
                        <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                        Logging in...
                    </span>
                </button>
            </div>
            <div class="text-center">
                <h6 class="fw-normal fs-14 text-dark mb-0">
                    <!--[if BLOCK]><![endif]--><?php if($role !== 'superadminstaff'): ?>
                        <a href="<?php echo e(route('admin.staff.login')); ?>" class="hover-a">
                            Login as Admin Staff
                        </a>
                    <?php else: ?>
                        <a href="<?php echo e(route('admin.login')); ?>" class="hover-a">
                            Login as Super Admin
                        </a>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </h6>
            </div>
        </div><!-- end card body -->
    </div><!-- end card -->
</div><?php /**PATH /var/www/predcare/resources/views/livewire/admin/auth/login-form.blade.php ENDPATH**/ ?>