<?php $__env->startSection('title', 'Doctor Dashboard'); ?>

<?php $__env->startSection('content'); ?>

<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>

    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Page Header -->
        <div class="d-flex align-items-sm-center justify-content-between flex-wrap gap-2 mb-4">
            <div>
                <h4 class="fw-bold mb-0">Doctor Dashboard</h4>
            </div>
            <div class="d-flex align-items-center flex-wrap gap-2">
                <a href="<?php echo e(route('doctor.appointments.create')); ?>" class="btn btn-primary d-inline-flex align-items-center"><i class="ti ti-plus me-1"></i>New Appointment</a>
                <!-- <a href="javascript:void(0);" class="btn btn-outline-white bg-white d-inline-flex align-items-center"><i
                        class="ti ti-calendar-time me-1"></i>Schedule Availability</a> -->
            </div>
        </div>
        <!-- End Page Header -->

        <!-- row start -->
        <div class="row">

            <!-- col start -->
            <div class="col-xl-4 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between mb-3">
                            <div>
                                <p class="mb-1">Total Appointments</p>
                                <div class="d-flex align-items-center gap-1">
                                    <h3 class="fw-bold mb-0"><?php echo e($totalAppointments); ?></h3>
                                    <span class="badge fw-medium bg-success flex-shrink-0">+100%</span>
                                </div>
                            </div>
                            <span class="avatar border border-primary text-primary rounded-2 flex-shrink-0"><i
                                    class="ti ti-calendar-heart fs-20"></i></span>
                        </div>
                        <div class="d-flex align-items-end">
                            <div id="s-col-5" class="chart-set"></div>
                            <!-- <span class="badge fw-medium badge-soft-success flex-shrink-0 ms-2">+21% <i
                                    class="ti ti-arrow-up ms-1"></i></span>
                            <p class="ms-1 fs-13 text-truncate">in last 7 Days </p> -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start -->
            <div class="col-xl-4 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between mb-3">
                            <div>
                                <p class="mb-1">Cancelled Appointments</p>
                                <div class="d-flex align-items-center gap-1">
                                    <h3 class="fw-bold mb-0"><?php echo e($totalCancelledAppointments); ?></h3>
                                    <span class="badge fw-medium bg-danger flex-shrink-0">-100%</span>
                                </div>
                            </div>
                            <span class="avatar border border-danger text-danger rounded-2 flex-shrink-0"><i
                                    class="ti ti-calendar-time fs-20"></i></span>
                        </div>
                        <div class="d-flex align-items-end">
                            <div id="s-col-6" class="chart-set"></div>
                            <!-- <span class="badge fw-medium badge-soft-danger flex-shrink-0 ms-2">+21% <i
                                    class="ti ti-arrow-down ms-1"></i></span>
                            <p class="ms-1 fs-13 text-truncate">in last 7 Days </p> -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start -->
            <div class="col-xl-4 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between mb-3">
                            <div>
                                <p class="mb-1">Total Patients</p>
                                <div class="d-flex align-items-center gap-1">
                                    <h3 class="fw-bold mb-0"><?php echo e($totalPatients); ?></h3>
                                    <span class="badge fw-medium bg-success flex-shrink-0">+100%</span>
                                </div>
                            </div>
                            <span class="avatar border border-success text-success rounded-2 flex-shrink-0"><i
                                    class="ti ti-users fs-20"></i></span>
                        </div>
                        <div class="d-flex align-items-end">
                            <div id="s-col-7" class="chart-set"></div>
                            <!-- <span class="badge fw-medium badge-soft-success flex-shrink-0 ms-2">+31% <i
                                    class="ti ti-arrow-up ms-1"></i></span>
                            <p class="ms-1 fs-13 text-truncate">in last 7 Days </p> -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- col end -->

        </div>
        <!-- row end -->

        <!-- row start -->
        <div class="row">

            <!-- col start -->
            <div class="col-xl-4 d-flex">
                <!-- card start -->
                <div class="card shadow-sm flex-fill w-100">
                    
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0 text-truncate">Upcoming Appointments</h5>
                    </div>
                    <div class="card-body">
                        <?php if($appointment): ?>
                        <div class="d-flex align-items-center mb-3">
                            <!-- <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                <img src="<?php echo e(asset('assets/img/doctors/doctor-01.jpg')); ?>" alt="img"
                                    class="rounded-circle">
                            </a> -->
                            <div>
                                <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);"class="fw-semibold"><?php echo e($appointment->patient_name); ?></a></h6>
                                <!-- <p class="mb-0 fs-13 text-truncate"></p> -->
                                <p class="mb-0 fs-13 text-truncate"><b>Appoinment Id:</b> <?php echo e($appointment->appointment_id); ?></p>
                            </div>
                        </div>
                        <h6 class="fs-14 fw-semibold mb-1">
                            <?php if($appointment->appointment_type === 'first_visit'): ?>
                                First Visit
                            <?php elseif($appointment->appointment_type === 'follow_up'): ?>
                                Follow-up
                            <?php else: ?>
                                <?php echo e(ucfirst($appointment->appointment_type)); ?>

                            <?php endif; ?>
                        </h6>
                        <div class="d-flex align-items-center gap-2 flex-wrap mb-3">
                            <p class="mb-0 d-inline-flex align-items-center"><i
                                    class="ti ti-calendar-time text-dark me-1"></i><?php echo e($appointment->appointment_date); ?></p>
                            <p class="mb-0 d-inline-flex align-items-center">
                                <?php
                                    $slots = json_decode($appointment->appointment_slot_time, true);
                                ?>

                                <?php if(!empty($slots)): ?>
                                    <ul class="list-unstyled mb-0">
                                        <?php $__currentLoopData = $slots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="d-inline-block me-2 mb-2 px-3 py-1 border rounded bg-light">
                                                <i class="ti ti-clock me-1 text-primary"></i> <?php echo e($slot); ?>

                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php else: ?>
                                    <p class="text-muted">No slots available</p>
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="row">
                            <div class="col">
                                <h6 class="fs-13 fw-semibold mb-1">Specialization</h6>
                                <p><?php echo e($appointment->specialization); ?></p>
                            </div>
                            <div class="col">
                                <h6 class="fs-13 fw-semibold mb-1">Type</h6>
                                <p class="text-truncate"><?php echo e($appointment->appointment_status); ?></p>
                            </div>
                        </div>
                        <!-- <div class="my-3 border-bottom pb-3">
                            <a href="javascript:void(0);" class="btn btn-primary w-100">Start Appointment</a>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <a href="javascript:void(0);" class="btn btn-dark w-100"><i
                                    class="ti ti-brand-hipchat me-1"></i>Chat Now</a>
                            <a href="javascript:void(0);" class="btn btn-outline-white w-100"><i
                                    class="ti ti-video me-1"></i>Video Consutation</a>
                        </div> -->
                        <?php else: ?>
                            <p class="text-center mb-0">No appointment available</p>
                        <?php endif; ?>
                    </div>
                </div>
                <!-- card end -->
            </div>
            <!-- col end -->

            <!-- col start -->
            <div class="col-xl-8 d-flex">
                <!-- card start -->
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Appointments</h5>
                        <!-- <div class="dropdown">
                            <a href="javascript:void(0);"
                                class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"
                                data-bs-toggle="dropdown">
                                Monthly <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu bg-white">
                                <li>
                                    <a class="dropdown-item" href="#">Monthly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Weekly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Yearly</a>
                                </li>
                            </ul>
                        </div> -->
                    </div>
                    <div class="card-body pb-0">
                        <div class="d-flex align-items-center justify-content-end gap-2 mb-1 flex-wrap mb-3">
                            <p class="mb-0 d-inline-flex align-items-center"><i
                                    class="ti ti-point-filled me-1 fs-18 text-success"></i>Completed Appointments: <?php echo e($totalCompleted); ?></p>
                            <p class="mb-0 d-inline-flex align-items-center"><i
                                    class="ti ti-point-filled me-1 fs-18 text-danger" style="color:#FF4560;"></i>Cancelled Appointments: <?php echo e($totalCancelled); ?></p>
                        </div>
                        <div class="chart-set" id="apps"></div>
                    </div>
                </div>
                <!-- card end -->
            </div>
            <!-- col end -->
        </div>
        <!-- row end -->

        <!-- row start --
        <div class="row row-cols-1 row-cols-xl-6 row-cols-md-3 row-cols-sm-2">

            <!-- col start --
            <div class="col">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <span class="avatar bg-primary rounded-2 fs-20 d-inline-flex mb-2"><i
                                class="ti ti-user"></i></span>
                        <p class="mb-1 text-truncate">Total Patient</p>
                        <h3 class="fw-bold mb-2">658</h3>
                        <p class="mb-0 text-success text-truncate">+31% Last Week</p>
                    </div>
                </div>
            </div>
            <!-- col end --

            <!-- col start --
            <div class="col">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <span class="avatar bg-secondary rounded-2 fs-20 d-inline-flex mb-2"><i
                                class="ti ti-video"></i></span>
                        <p class="mb-1 text-truncate">Video Consultation</p>
                        <h3 class="fw-bold mb-2">256</h3>
                        <p class="mb-0 text-danger text-truncate">-21% Last Week</p>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start --
            <div class="col">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <span class="avatar bg-success rounded-2 fs-20 d-inline-flex mb-2"><i
                                class="ti ti-calendar-up"></i></span>
                        <p class="mb-1 text-truncate">Rescheduled</p>
                        <h3 class="fw-bold mb-2">141</h3>
                        <p class="mb-0 text-success text-truncate">+64% Last Week</p>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start --
            <div class="col">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <span class="avatar bg-danger rounded-2 fs-20 d-inline-flex mb-2"><i
                                class="ti ti-checklist"></i></span>
                        <p class="mb-1 text-truncate">Pre Visit Bookings</p>
                        <h3 class="fw-bold mb-2">524</h3>
                        <p class="mb-0 text-success text-truncate">+38% Last Week</p>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start --
            <div class="col">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <span class="avatar bg-info rounded-2 fs-20 d-inline-flex mb-2"><i
                                class="ti ti-calendar-share"></i></span>
                        <p class="mb-1 text-truncate">Walkin Bookings</p>
                        <h3 class="fw-bold mb-2">21</h3>
                        <p class="mb-0 text-success text-truncate">+95% Last Week</p>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start --
            <div class="col">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <span class="avatar bg-soft-success text-success rounded-2 fs-20 d-inline-flex mb-2"><i
                                class="ti ti-carousel-vertical"></i></span>
                        <p class="mb-1 text-truncate">Follow Ups</p>
                        <h3 class="fw-bold mb-2">451</h3>
                        <p class="mb-0 text-success text-truncate">+76% Last Week</p>
                    </div>
                </div>
            </div>
            <!-- col end --

        </div>
        !-- row start -->

        <!-- row start -->
        <div class="row">
            <div class="col-12 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Recent Appointments</h5>
                        <!-- <div class="dropdown">
                            <a href="javascript:void(0);"
                                class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"
                                data-bs-toggle="dropdown">
                                Weekly <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu bg-white">
                                <li>
                                    <a class="dropdown-item" href="#">Monthly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Weekly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Yearly</a>
                                </li>
                            </ul>
                        </div> -->
                    </div>
                    <div class="card-body">
                        <!-- Table start -->
                        <div class="table-responsive table-nowrap">
                            <table class="table border">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Appointment ID</th>
                                        <th>Patient</th>
                                        <th>Doctor</th>
                                        <th>Specialization</th>
                                        <th>Appointment Date</th>
                                        <th>Appointment Time (Slot)</th>
                                        <th>Consultation Fees</th>
                                        <th>Appointment Type</th>
                                        <th>Reason</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($item->appointment_id); ?></td>
                                        <td><?php echo e($item->patient->name ?? 'N/A'); ?></td>
                                        <td><?php echo e($item->doctor->name ?? 'N/A'); ?></td>
                                        <td><?php echo e($item->specialization); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($item->appointment_date)->isoFormat('D, MMMM YYYY')); ?></td>
                                        <td>
                                            <ul class="list-unstyled mb-0">
                                                <?php $__currentLoopData = json_decode($item->appointment_slot_time); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="d-inline-block me-2 mb-2 px-3 border rounded bg-light">
                                                        <i class="ti ti-clock me-1 text-primary"></i> <?php echo e($slot); ?>

                                                    </li><br>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </td>
                                        <td>
                                            <strong>
                                                <?php if($item->fee_type === 'in_person_fee'): ?>
                                                    In-Person
                                                <?php elseif($item->fee_type === 'video_fee'): ?>
                                                    Video
                                                <?php else: ?>
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $item->fee_type))); ?>

                                                <?php endif; ?>
                                            </strong>
                                            - $<?php echo e($item->appointment_fee); ?>

                                        </td>
                                        <td>
                                            <?php if($item->appointment_type === 'first_visit'): ?>
                                                First Visit
                                            <?php elseif($item->appointment_type === 'follow_up'): ?>
                                                Follow Up
                                            <?php else: ?>
                                                <?php echo e(ucfirst($item->appointment_type)); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <p class="reason-text">
                                                <?php echo e($item->reason); ?>

                                            </p>
                                            <a href="#" class="read-more" style="color:blue;cursor:pointer;">Read More</a>
                                        </td>
                                        <td>  
                                            
                                            <?php if($item->appointment_status == 'completed'): ?>
                                                <span class="badge bg-success fw-medium">Completed</span>
                                            <?php elseif($item->appointment_status == 'cancelled'): ?>
                                                <span class="badge bg-danger fw-medium">Cancelled</span>
                                            <?php else: ?>
                                                <?php if($item->fee_type === 'in_person_fee'): ?>
                                                
                                                <?php elseif($item->fee_type === 'video_fee'): ?>       
                                                    <div class="">
                                                        <a href="<?php echo e(route('doctor.call', [
                                                                'appointment_id' => $item->appointment_id,
                                                                'doctor_id'      => auth('doctor')->id(),
                                                                'patient_id'     => $item->patient_id, // optional but nice
                                                            ])); ?>"
                                                            class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2"
                                                            data-bs-toggle="tooltip" title="Start Video Call"> <i class="ti ti-video"></i>
                                                        </a>
                                                        
                                                        <!-- <a href="<?php echo e(route('doctor.call')); ?>" class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14" data-bs-toggle="tooltip" title="Start Chat">
                                                            <i class="ti ti-message-circle"></i>
                                                        </a> -->
                                                    </div>
                                                <?php endif; ?>

                                                <span class="badge bg-secondary fw-medium"><?php echo e(ucfirst($item->appointment_status)); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <?php if($item->appointment_status == 'online' || $item->appointment_status == 'offline'): ?>
                                                        <a href="<?php echo e(route('doctor.appointments.update-status', ['id' => $item->id, 'status' => 'completed'])); ?>" class="dropdown-item d-flex align-items-center text-success">
                                                            <i class="ti ti-check me-2 text-success"></i> Mark as Complete
                                                        </a>
                                                    <?php elseif($item->appointment_status == 'completed'): ?>
                                                        <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center disabled text-success" style="opacity: 0.5; pointer-events: none;">
                                                            <i class="ti ti-check me-2 text-success"></i> Already Completed
                                                        </a>
                                                    <?php endif; ?>
                                                </li>
                                                <li>
                                                    <?php if($item->appointment_status == 'online' || $item->appointment_status == 'offline'): ?>
                                                        <a href="<?php echo e(route('doctor.appointments.update-status', ['id' => $item->id, 'status' => 'cancelled'])); ?>" class="dropdown-item d-flex align-items-center text-danger">
                                                            <i class="ti ti-x me-2 text-danger"></i> Mark as Cancelled
                                                        </a>
                                                    <?php elseif($item->appointment_status == 'cancelled'): ?>
                                                        <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center disabled text-danger" style="opacity: 0.5; pointer-events: none;">
                                                            <i class="ti ti-x me-2 text-danger"></i> Already Cancelled
                                                        </a>
                                                    <?php endif; ?>
                                                </li>
                                                <li>
                                                    <form method="POST" action="<?php echo e(route('doctor.appointments.destroy', $item->id)); ?>" class="delete-form d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="button" class="dropdown-item d-flex align-items-center text-danger confirm-delete"
                                                                data-doctor="<?php echo e($item->doctor->name); ?>">
                                                            <i class="ti ti-trash me-2"></i> Delete
                                                        </button>
                                                    </form>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- Table end -->
                    </div>
                </div>
            </div>
        </div>
        <!-- row end -->

        <!-- row start --
        <div class="row">

            <!-- col start --
            <div class="col-xl-4 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Availability</h5>
                        <div class="dropdown">
                            <a href="javascript:void(0);"
                                class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"
                                data-bs-toggle="dropdown">
                                Trustcare Clinic <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu bg-white">
                                <li>
                                    <a class="dropdown-item" href="javascript:void(0);">CureWell Medical Hub</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="javascript:void(0);">Trustcare Clinic</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="javascript:void(0);">NovaCare Medical</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="javascript:void(0);">Greeny Medical Clinic</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                            <p class="text-dark fw-semibold mb-0">Mon</p>
                            <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM -
                                12:30 PM</p>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                            <p class="text-dark fw-semibold mb-0">Tue</p>
                            <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM -
                                12:30 PM</p>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                            <p class="text-dark fw-semibold mb-0">Wed</p>
                            <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM -
                                12:30 PM</p>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                            <p class="text-dark fw-semibold mb-0">Thu</p>
                            <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM -
                                12:30 PM</p>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                            <p class="text-dark fw-semibold mb-0">Fri</p>
                            <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM -
                                12:30 PM</p>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                            <p class="text-dark fw-semibold mb-0">Sat</p>
                            <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM -
                                12:30 PM</p>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-2 pb-2">
                            <p class="text-dark fw-semibold mb-0">Sun</p>
                            <p class="mb-0 d-inline-flex align-items-center text-danger"><i
                                    class="ti ti-clock me-1"></i>Closed</p>
                        </div>
                        <a href="javascript:void(0);" class="btn btn-light w-100 mt-2 fs-13">Edit Availability</a>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start --
            <div class="col-xl-4 col-lg-6 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0 text-truncate">Appointment Statistics</h5>
                        <div class="dropdown">
                            <a href="javascript:void(0);"
                                class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"
                                data-bs-toggle="dropdown">
                                Monthly <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu bg-white">
                                <li>
                                    <a class="dropdown-item" href="#">Monthly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Weekly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Yearly</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="circle-chart-2" class="chart-set"></div>
                        <div class="d-flex align-items-center justify-content-center gap-2 mt-3">
                            <div class="text-center">
                                <p class="d-flex align-items-center mb-1 fs-13"><i
                                        class="ti ti-circle-filled text-success fs-10 me-1"></i>Completed</p>
                                <h5 class="fw-bold mb-0">260</h5>
                            </div>
                            <div class="text-center">
                                <p class="d-flex align-items-center mb-1 fs-13"><i
                                        class="ti ti-circle-filled text-warning fs-10 me-1"></i>Pending</p>
                                <h5 class="fw-bold mb-0">21</h5>
                            </div>
                            <div class="text-center">
                                <p class="d-flex align-items-center mb-1 fs-13"><i
                                        class="ti ti-circle-filled text-danger fs-10 me-1"></i>Cancelled</p>
                                <h5 class="fw-bold mb-0">50</h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- col end --

            <!-- col start --
            <div class="col-xl-4 col-lg-6 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Top Patients</h5>
                        <div class="dropdown">
                            <a href="javascript:void(0);"
                                class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"
                                data-bs-toggle="dropdown">
                                Weekly <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu bg-white">
                                <li>
                                    <a class="dropdown-item" href="#">Monthly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Weekly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Yearly</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between mb-4">
                            <div class="d-flex align-items-center">
                                <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                    <img src="<?php echo e(asset('assets/img/profiles/avatar-06.jpg')); ?>" alt="img"
                                        class="rounded-circle">
                                </a>
                                <div>
                                    <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);"
                                            class="fw-medium">Alberto Ripley</a></h6>
                                    <p class="mb-0 fs-13 text-truncate">+1 56556 54565</p>
                                </div>
                            </div>
                            <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">20
                                Appointments</span>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-4">
                            <div class="d-flex align-items-center">
                                <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                    <img src="<?php echo e(asset('assets/img/profiles/avatar-12.jpg')); ?>" alt="img"
                                        class="rounded-circle">
                                </a>
                                <div>
                                    <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);"
                                            class="fw-medium">Susan Babin</a></h6>
                                    <p class="mb-0 fs-13 text-truncate">+1 65658 95654</p>
                                </div>
                            </div>
                            <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">18
                                Appointments</span>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-4">
                            <div class="d-flex align-items-center">
                                <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                    <img src="<?php echo e(asset('assets/img/profiles/avatar-08.jpg')); ?>" alt="img"
                                        class="rounded-circle">
                                </a>
                                <div>
                                    <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);"
                                            class="fw-medium">Carol Lam</a></h6>
                                    <p class="mb-0 fs-13 text-truncate">+1 55654 56647</p>
                                </div>
                            </div>
                            <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">16
                                Appointments</span>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-4">
                            <div class="d-flex align-items-center">
                                <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                    <img src="<?php echo e(asset('assets/img/profiles/avatar-22.jpg')); ?>" alt="img"
                                        class="rounded-circle">
                                </a>
                                <div>
                                    <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);"
                                            class="fw-medium">Marsha Noland</a></h6>
                                    <p class="mb-0 fs-13 text-truncate">+1 65668 54558</p>
                                </div>
                            </div>
                            <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">14
                                Appointments</span>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-0">
                            <div class="d-flex align-items-center">
                                <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                    <img src="<?php echo e(asset('assets/img/profiles/avatar-17.jpg')); ?>" alt="img"
                                        class="rounded-circle">
                                </a>
                                <div>
                                    <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);"
                                            class="fw-medium">Irma Armstrong</a></h6>
                                    <p class="mb-0 fs-13 text-truncate">+1 45214 66568</p>
                                </div>
                            </div>
                            <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">12
                                Appointments</span>
                        </div>
                    </div>
                </div>
            </div>
            <!-- col end --

        </div>
        !-- row end -->

    </div>
    <!-- End Content -->

<script>
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".reason-text").forEach(function (p) {
        const fullText = p.innerText.trim();
        const words = fullText.split(/\s+/);
        const readMore = p.nextElementSibling; // jo <a> tag hai usko le raha hai

        // ✅ Pehle 10 words hi dikhaye
        if (words.length > 10) {
            const shortText = words.slice(0, 10).join(" ");
            p.innerText = shortText + "...";
        } else {
            // Agar 10 words se kam hai to "Read More" hide kar do
            readMore.style.display = "none";
        }

        readMore.addEventListener("click", function (e) {
            e.preventDefault();
            p.innerHTML = formatTextInLines(fullText, 20); // ✅ 50 words per line
            readMore.style.display = "none";
        });
    });

    function formatTextInLines(text, wordsPerLine = 20) {
        const words = text.split(/\s+/);
        let lines = [];
        for (let i = 0; i < words.length; i += wordsPerLine) {
            lines.push(words.slice(i, i + wordsPerLine).join(" "));
        }
        return lines.join("<br>");
    }
});
</script>

<!-- Delete Confirmation Modal -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".confirm-delete").forEach(function (button) {
            button.addEventListener("click", function () {
                const form = this.closest('form');
                const name = this.dataset.name || 'this appointment';

                Swal.fire({
                    title: 'Are you sure?',
                    text: `You are about to delete ${name}.`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Yes, delete it!',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });
        });
    });
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

<script>
document.addEventListener("DOMContentLoaded", function() {
    var sCol = {
        chart: {
            height: 250,
            type: 'line',
            toolbar: { show: false },
            stacked: false
        },
        stroke: { width: [0, 2], curve: 'smooth' },
        plotOptions: { bar: { columnWidth: '15%', borderRadius: 4 } },
        dataLabels: { enabled: false },
        series: [
            {
                name: 'Completed',
                type: 'bar',
                data: <?php echo json_encode($completed, 15, 512) ?> // Laravel se dynamic data
            },
            {
                name: 'Cancelled',
                type: 'area',
                data: <?php echo json_encode($cancelled, 15, 512) ?> // Laravel se dynamic data
            }
        ],
        colors: ['#00B96B', '#FF4560'],
        xaxis: {
            categories: <?php echo json_encode($months, 15, 512) ?>, // Month names
            labels: { style: { fontSize: '13px' } }
        },
        yaxis: {
            min: 0,
            labels: { style: { fontSize: '13px' }, offsetX: -10 }
        },
        tooltip: {
            shared: true,
            intersect: false
        },
        legend: { show: true },
        grid: {
            borderColor: '#eee',
            strokeDashArray: 4,
            padding: { left: 0, right: -10 }
        }
    };

    var chart = new ApexCharts(document.querySelector("#apps"), sCol);
    chart.render();
});
</script>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/predcare/resources/views/doctor/doctor-dashboard.blade.php ENDPATH**/ ?>