<div class="content" id="profilePage">
    <!-- Page Header -->
    <div class="mb-3 border-bottom pb-3">
        <h4 class="fw-bold mb-0">Settings</h4>
    </div>
    <!-- End Page Header -->

    <div class="card">
        <div class="card-body p-0">
            <div class="settings-wrapper d-flex">

                <!-- Start Settings Sidebar -->
                <div class="sidebars settings-sidebar" id="sidebar2">
                    <div class="sidebar-inner" data-simplebar>
                        <div id="sidebar-menu5" class="sidebar-menu mt-0 p-0">
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);" class="active">
                                        <i class="ti ti-user-cog me-2"></i><span>Account Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="" class="active">Profile</a></li>
                                        <li><a href="javascript:void(0);">Security</a></li>
                                        <li><a href="javascript:void(0);">Notifications</a></li>
                                        <li><a href="javascript:void(0);">Integrations</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-world-cog me-2"></i><span>Website Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="javascript:void(0);">Organization</a></li>
                                        <li><a href="javascript:void(0);">Localization</a></li>
                                        <li><a href="javascript:void(0);">Prefixes</a></li>
                                        <li><a href="javascript:void(0);">SEO Setup</a></li>
                                        <li><a href="javascript:void(0);">Language</a></li>
                                        <li><a href="javascript:void(0);">Maintenance Mode</a></li>
                                        <li><a href="javascript:void(0);">Login & Register</a></li>
                                        <li><a href="javascript:void(0);">Preferences</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-building-hospital me-2"></i><span>Clinic Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="javascript:void(0);">Appointment</a></li>
                                        <li><a href="javascript:void(0);">Working Hours</a></li>
                                        <li><a href="javascript:void(0);">Cancellation Reason</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-device-mobile-cog me-2"></i><span>App Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="javascript:void(0);">Invoice Settings</a></li>
                                        <li><a href="javascript:void(0);">Invoice Templates</a></li>
                                        <li><a href="javascript:void(0);">Signatures</a></li>
                                        <li><a href="javascript:void(0);">Custom Fields</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-device-desktop-cog me-2"></i><span>System Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="javascript:void(0);">Email Settings</a></li>
                                        <li><a href="javascript:void(0);">Email Templates</a></li>
                                        <li><a href="javascript:void(0);">SMS Gateways</a></li>
                                        <li><a href="javascript:void(0);">SMS Templates</a></li>
                                        <li><a href="javascript:void(0);">GDPR Cookies</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-settings-dollar me-2"></i><span>Finance & Accounts</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="javascript:void(0);">Payment Methods</a></li>
                                        <li><a href="javascript:void(0);">Bank Accounts</a></li>
                                        <li><a href="javascript:void(0);">Tax Rates</a></li>
                                        <li><a href="javascript:void(0);">Currencies</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-settings-2 me-2"></i><span>Other Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="javascript:void(0);">Sitemap</a></li>
                                        <li><a href="javascript:void(0);">Clear Cache</a></li>
                                        <li><a href="javascript:void(0);">Storage</a></li>
                                        <li><a href="javascript:void(0);">Cronjob</a></li>
                                        <li><a href="javascript:void(0);">Ban IP Address</a></li>
                                        <li><a href="javascript:void(0);">System Backup</a></li>
                                        <li><a href="javascript:void(0);">Database Backup</a></li>
                                        <li><a href="javascript:void(0);">System Update</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- End Settings Sidebar -->

                <div class="card flex-fill mb-0 border-0 bg-light-500 shadow-none">
                    <div class="card-header border-bottom px-0 mx-3">
                        <h5 class="fw-bold">Basic Information</h5>
                    </div>
                    <div class="card-body px-0 mx-3">
                        <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo e(session('message')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- start row -->
                        <div class="row border-bottom mb-3">
                            <div class="col-lg-12">
                                <!-- Profile Image Section -->
                                <!-- Profile Image Section -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-2">
                                        <label class="form-label mb-0">Profile Image<span
                                                class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-10">
                                        <div class="position-relative d-inline-block">
                                            <!--[if BLOCK]><![endif]--><?php if($newProfilePicturePreview): ?>
                                                <!-- When new image is selected (preview) -->
                                                <div class="position-relative">
                                                    <img src="<?php echo e($newProfilePicturePreview); ?>" alt="Profile"
                                                        class="rounded-circle"
                                                        style="width: 80px; height: 80px; object-fit: cover;">
                                                    <button wire:click.prevent="removeProfilePicture" type="button"
                                                        class="btn btn-danger btn-icon btn-xs position-absolute rounded-circle"
                                                        style="top: -5px; right: -5px; width: 20px; height: 20px; padding: 0; border: 2px solid white;">
                                                        <i class="ti ti-x" style="font-size: 10px;"></i>
                                                    </button>
                                                </div>
                                            <?php elseif($currentProfilePicture): ?>
                                                <!-- When existing image is present -->
                                                <div class="position-relative">
                                                    <img src="<?php echo e(Storage::url($currentProfilePicture)); ?>"
                                                        alt="Profile" class="rounded-circle"
                                                        style="width: 80px; height: 80px; object-fit: cover;">
                                                    <button wire:click.prevent="removeExistingProfilePicture"
                                                        type="button"
                                                        class="btn btn-danger btn-icon btn-xs position-absolute rounded-circle"
                                                        style="top: -5px; right: -5px; width: 20px; height: 20px; padding: 0; border: 2px solid white;">
                                                        <i class="ti ti-x" style="font-size: 10px;"></i>
                                                    </button>
                                                </div>
                                            <?php else: ?>
                                                <!-- When no image - show initial letter avatar -->
                                                <div class="position-relative">
                                                    <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center"
                                                        style="width: 80px; height: 80px; font-size: 32px; font-weight: bold;">
                                                        <?php echo e(strtoupper(substr($name ?: 'U', 0, 1))); ?>

                                                    </div>
                                                    <a href="javascript:void(0);"
                                                        class="position-absolute bottom-0 end-0 bg-dark rounded-circle p-1"
                                                        onclick="document.getElementById('profileUpload').click();">
                                                        <i class="ti ti-camera text-white"
                                                            style="font-size: 12px;"></i>
                                                    </a>
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['profile_picture'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger d-block mt-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->

                                        <!--[if BLOCK]><![endif]--><?php if($newProfilePicturePreview || $currentProfilePicture): ?>
                                            <div class="mt-2">
                                                <button type="button" class="btn btn-outline-primary btn-sm"
                                                    onclick="document.getElementById('profileUpload').click();">
                                                    Change Image
                                                </button>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <input type="file" wire:model="profile_picture" id="profileUpload"
                                            style="display: none;" accept="image/*">
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- First Name -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">First Name<span
                                                class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="first_name" type="text" class="form-control"
                                            placeholder="Enter first name">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Last Name -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Last Name<span
                                                class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="last_name" type="text" class="form-control"
                                            placeholder="Enter last name">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Full Name -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Full Name<span
                                                class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="name" type="text" class="form-control"
                                            placeholder="Enter your full name">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Email -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Email<span
                                                class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="email" type="email" class="form-control"
                                            placeholder="Enter your email">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Phone Number -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Phone Number<span
                                                class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="phone_number" type="text" class="form-control"
                                            placeholder="Enter phone number">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Alternate Phone -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Alternate Phone</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="alternate_phone" type="text" class="form-control"
                                            placeholder="Enter alternate phone">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['alternate_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                        <!-- Additional Information Section -->
                        <div class="row border-bottom mb-3">
                            <div class="mb-3">
                                <h5 class="fw-bold mb-0">Additional Information</h5>
                            </div>

                            <div class="col-lg-6">
                                <!-- Date of Birth -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Date of Birth</label>
                                    </div>
                                    <div class="col-lg-8 input-icon-end position-relative">
                                        <input wire:ignore id="date_of_birth" type="text"
                                            class="form-control datetimepicker" placeholder="dd/mm/yyyy">
                                        <span class="input-icon-addon me-2">
                                            <i class="ti ti-calendar"></i>
                                        </span>

                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Gender -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Gender</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <select wire:model="gender" class="form-select">
                                            <option value="">Select Gender</option>
                                            <option value="male">Male</option>
                                            <option value="female">Female</option>
                                            <option value="other">Other</option>
                                        </select>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Timezone -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Timezone</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <select wire:model="timezone" class="form-select">
                                            <option value="">Select Timezone</option>
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = timezone_identifiers_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tz): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($tz); ?>"><?php echo e($tz); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </select>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['timezone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                        <!-- Password Section -->
                        <div class="row mb-3">
                            <div class="mb-3">
                                <h5 class="fw-bold mb-0">Change Password</h5>
                            </div>

                            <div class="col-lg-6">
                                <!-- New Password -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">New Password</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="password" type="password" class="form-control"
                                            placeholder="Enter new password">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Confirm Password -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Confirm Password</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="password_confirmation" type="password"
                                            class="form-control" placeholder="Confirm new password">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                        <div class="d-flex align-items-center justify-content-end">
                            <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-light me-3">Cancel</a>
                            <button wire:click="save" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                </div>
            </div>

        </div><!-- end card body -->
    </div><!-- end card -->
</div>

<?php /**PATH /var/www/predcare/resources/views/livewire/admin/profile/profile-component.blade.php ENDPATH**/ ?>