<div class="content">

    <!-- Start Page Header -->
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">
                Doctor List
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    Total Doctors: <?php echo e($totalDoctors); ?>

                </span>
            </h4>
        </div>

        <div class="text-end d-flex">
            <!-- dropdown-->
            

            <a href="<?php echo e(route('admin.doctor-management.create')); ?>" class="btn btn-primary ms-2 fs-13 btn-md"><i
                    class="ti ti-plus me-1"></i>New
                Doctor</a>
        </div>
    </div>
    <!-- End Page Header -->

    <div class=" d-flex align-items-center justify-content-between flex-wrap row-gap-3">
        <div>
            <div class="search-set mb-3">
                <div class="d-flex align-items-center flex-wrap gap-2">
                    <div class="table-search d-flex align-items-center mb-0">
                        <div class="search-input">
                            <input type="text" wire:model.live.debounce.300ms="searchTerm"
                                class="form-control form-control-md" placeholder="Search doctors...">
                            <a href="javascript:void(0);" class="btn-searchset"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="d-flex table-dropdown mb-3 pb-1 right-content align-items-center flex-wrap row-gap-3">
            <div class="dropdown me-2">
                <a href="javascript:void(0);"
                    class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                    data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                </a>
                <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                    <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                        <h4 class="mb-0">Filter</h4>
                        <div class="d-flex align-items-center">
                            <a href="javascript:void(0);" wire:click="resetFilters"
                                class="link-danger text-decoration-underline">Clear All</a>
                        </div>
                    </div>
                    <form wire:submit.prevent="applyFilters">
                        <div class="filter-body pb-0">
                            <!-- Status Filter -->
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Status</label>
                                    <a href="javascript:void(0);" wire:click="$set('statusFilter', 'all')"
                                        class="link-primary mb-1">Reset</a>
                                </div>
                                <select class="form-select" wire:model="statusFilter">
                                    <option value="all">All Status</option>
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>

                            <!-- Specialization Filter -->
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Specialization</label>
                                    <a href="javascript:void(0);" wire:click="$set('specializationFilter', 'all')"
                                        class="link-primary mb-1">Reset</a>
                                </div>
                                <select class="form-select" wire:model="specializationFilter">
                                    <option value="all">All Specializations</option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $specializations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialization): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($specialization); ?>"><?php echo e($specialization); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                            </div>

                            <!-- Clinic Filter -->
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Clinic</label>
                                    <a href="javascript:void(0);" wire:click="$set('clinicFilter', 'all')"
                                        class="link-primary mb-1">Reset</a>
                                </div>
                                <select class="form-select" wire:model="clinicFilter">
                                    <option value="all">All Clinics</option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $clinics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clinic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($clinic->id); ?>"><?php echo e($clinic->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                            </div>
                        </div>
                        <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                            <a href="javascript:void(0);" class="btn btn-light btn-md me-2" id="close-filter">Close</a>
                            <button type="submit" class="btn btn-primary btn-md">Apply Filters</button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="dropdown">
                <a href="javascript:void(0);"
                    class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                    data-bs-toggle="dropdown">
                    <span class="me-1"> Sort By : </span> Recent
                </a>
                <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1">Recently Added</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1">Ascending</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1">Desending</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1">Last Month</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1">Last 7 Days</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table datatable table-nowrap">
            <thead class="">
                <tr>
                    <th class="no-sort">
                        Doctor
                    </th>
                    <th>Specialization</th>
                    <th>License Number</th>
                    <th>Primary Clinic</th>
                    <th>Status</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        
                        <td>
                            <div class="d-flex align-items-center">
                                <a href="<?php echo e(route('admin.doctor-management.view', $user->id)); ?>"
                                    class="avatar avatar-md me-2">
                                    <!--[if BLOCK]><![endif]--><?php if($user->doctor?->profile_image && file_exists(public_path('storage/' . $user->doctor->profile_image))): ?>
                                        <img src="<?php echo e(asset('storage/' . $user->doctor->profile_image)); ?>"
                                            alt="<?php echo e($user->name); ?>" class="rounded-circle">
                                    <?php else: ?>
                                        <div
                                            class="avatar-initial rounded-circle bg-primary text-white d-flex align-items-center justify-content-center fw-bold">
                                            <?php echo e($this->getInitials($user->name)); ?>

                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </a>
                                <a href="<?php echo e(route('admin.doctor-management.view', $user->id)); ?>"
                                    class="text-dark fw-semibold">
                                    <?php echo e($user->name); ?>

                                    <span class="text-body fs-13 fw-normal d-block"><?php echo e($user->email); ?></span>
                                </a>
                            </div>
                        </td>

                        
                        <!-- <td>
                            <span class="fs-13"><?php echo e($user->doctor?->specialization ?? 'N/A'); ?></span>
                        </td> -->
                        <?php
                            $spec = $user->doctor?->specialization ?? null;
                            $arr = [];

                            if (is_array($spec)) {
                                $arr = $spec;
                            } elseif (is_string($spec)) {
                                // कोशिश करो JSON decode करने की
                                $decoded = json_decode($spec, true);
                                if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                                    $arr = $decoded;
                                } else {
                                    // नहीं तो comma-separated मान कर split करो
                                    $arr = array_filter(array_map('trim', explode(',', $spec)));
                                }
                            }
                        ?>

                        <td>
                            <span class="fs-13">
                                <?php echo e(count($arr) ? implode(',', $arr) : 'N/A'); ?>

                            </span>
                        </td>

                        
                        <td>
                            <span class="fs-13"><?php echo e($user->doctor?->license_number ?? 'N/A'); ?></span>
                        </td>

                        
                        <td>
                            <?php
                                $primaryClinic = $user->clinics->where('pivot.is_primary', true)->first();
                            ?>
                            <span class="fs-13"><?php echo e($primaryClinic ? $primaryClinic->name : 'N/A'); ?></span>
                        </td>

                        
                        <td>
                            <!--[if BLOCK]><![endif]--><?php if($user->status === 'active'): ?>
                                <span class="badge badge-soft-success border border-success">Active</span>
                            <?php else: ?>
                                <span class="badge badge-soft-danger border border-danger">Inactive</span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </td>

                        

                        <td>
                            <div class="d-flex align-items-center">
                                
                                <div class="action-item">
                                    <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                        <i class="ti ti-dots-vertical"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end bg-white">
                                        <li>
                                            <a href="<?php echo e(route('admin.doctor-management.edit', $user->id)); ?>"
                                                class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-edit me-2"></i> Edit
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo e(route('admin.doctor-management.view', $user->id)); ?>"
                                                class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-eye me-2"></i> View
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);"
                                                class="dropdown-item d-flex align-items-center"
                                                wire:click="toggleStatus(<?php echo e($user->id); ?>)">
                                                <i class="ti ti-power me-2"></i>
                                                <?php echo e($user->status === 'active' ? 'Deactivate' : 'Activate'); ?>

                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);"
                                                class="dropdown-item d-flex align-items-center text-danger"
                                                data-bs-toggle="modal" data-bs-target="#delete_doctor"
                                                onclick="setDeleteDoctorId(<?php echo e($user->id); ?>, '<?php echo e($user->name); ?>')">
                                                <i class="ti ti-trash me-2"></i> Delete
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center">No doctors found.</td>
                    </tr>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </tbody>
        </table>
    </div>
    <?php if (isset($component)) { $__componentOriginal7a1de95135fea4b7a0f524148344a9f0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7a1de95135fea4b7a0f524148344a9f0 = $attributes; } ?>
<?php $component = App\View\Components\Table\Pagination::resolve(['paginator' => $users,'position' => 'both'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('table.pagination'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Table\Pagination::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7a1de95135fea4b7a0f524148344a9f0)): ?>
<?php $attributes = $__attributesOriginal7a1de95135fea4b7a0f524148344a9f0; ?>
<?php unset($__attributesOriginal7a1de95135fea4b7a0f524148344a9f0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7a1de95135fea4b7a0f524148344a9f0)): ?>
<?php $component = $__componentOriginal7a1de95135fea4b7a0f524148344a9f0; ?>
<?php unset($__componentOriginal7a1de95135fea4b7a0f524148344a9f0); ?>
<?php endif; ?>

    <!-- Start Delete Modal -->
    <div class="modal fade" id="delete_doctor">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-body text-center position-relative">
                    <img src="<?php echo e(asset('assets/img/bg/delete-modal-bg-01.png')); ?>" alt=""
                        class="img-fluid position-absolute top-0 start-0">
                    <img src="<?php echo e(asset('assets/img/bg/delete-modal-bg-02.png')); ?>" alt=""
                        class="img-fluid position-absolute bottom-0 end-0">

                    <div class="mb-3">
                        <span class="avatar avatar-lg bg-danger text-white"><i class="ti ti-trash fs-24"></i></span>
                    </div>
                    <h5 class="fw-bold mb-1">Delete Confirmation</h5>
                    <p class="mb-3">Are you sure you want to delete <strong id="doctorName"></strong>?</p>
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btn btn-light position-relative z-1 me-3"
                            data-bs-dismiss="modal">Cancel</a>
                        <a href="javascript:void(0);" class="btn btn-danger position-relative z-1"
                            id="confirmDeleteDoctorBtn">Yes, Delete</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Delete Modal -->
    <style>
        .avatar-initial {
            width: 40px;
            height: 40px;
            font-size: 16px;
            font-weight: 600;
        }

        .avatar .avatar-initial {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        .avatar-initial.bg-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
        }

        .avatar-initial.bg-success {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%) !important;
        }

        .avatar-initial.bg-info {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%) !important;
        }

        .avatar-initial.bg-warning {
            background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%) !important;
        }

        .avatar-initial.bg-danger {
            background: linear-gradient(135deg, #fa709a 0%, #fee140 100%) !important;
        }

        .avatar-initial.bg-secondary {
            background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%) !important;
        }
    </style>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        let doctorIdToDelete = null;

        function setDeleteDoctorId(doctorId, doctorName) {
            doctorIdToDelete = doctorId;
            document.getElementById('doctorName').textContent = doctorName;
        }

        document.getElementById('confirmDeleteDoctorBtn').addEventListener('click', function() {
            if (doctorIdToDelete) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('deleteDoctor', doctorIdToDelete);

                const modal = bootstrap.Modal.getInstance(document.getElementById('delete_doctor'));
                modal.hide();

                doctorIdToDelete = null;
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/predcare/resources/views/livewire/admin/doctor/doctor-list.blade.php ENDPATH**/ ?>