<div>
    <h5 class="fw-bold pb-3 mb-4 border-1 border-bottom">Basic Information</h5>

    <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
        <div class="alert alert-success">
            <?php echo e(session('message')); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <form wire:submit.prevent="save">
        <!-- Profile Image -->
        <div class="row border-bottom mb-3">
            <!-- Profile Image -->
            <div class="col-lg-12">
                <div class="mb-3 d-flex align-items-center">
                    <label class="form-label mb-0 fw-medium">Profile Image</label>
                    <div
                        class="drag-upload-btn avatar avatar-xxl rounded-circle bg-light text-muted position-relative overflow-hidden z-1 mb-2 ms-4 p-0">

                        <?php
                            $imageUrl = $this->getProfileImageUrl();
                        ?>

                        <!--[if BLOCK]><![endif]--><?php if($imageUrl): ?>
                            <!-- Show current image -->
                            <img src="<?php echo e($imageUrl); ?>" alt="Profile" class="w-100 h-100" style="object-fit: cover;">
                            <!-- Remove button -->
                            <div class="position-absolute top-0 end-0 m-1">
                                <button type="button" wire:click="removeProfileImage"
                                    class="btn btn-danger btn-sm rounded-circle p-1"
                                    style="width: 24px; height: 24px; z-index: 10;">
                                    <i class="ti ti-x fs-12"></i>
                                </button>
                            </div>
                        <?php else: ?>
                            <!-- Show placeholder when no image -->
                            <i class="ti ti-user-plus fs-16"></i>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- File input -->
                        <input type="file" wire:model="profile_image"
                            class="form-control image-sign position-absolute top-0 start-0 w-100 h-100 opacity-0"
                            accept="image/*" style="cursor: pointer;">

                        <!-- Camera icon overlay -->
                        <div class="position-absolute bottom-0 end-0 w-100 h-25 bg-dark d-flex align-items-center justify-content-center"
                            style="z-index: 1;">
                            <span class="text-white d-flex align-items-center justify-content-center">
                                <i class="ti ti-photo fs-14"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Loading indicator -->
                <div wire:loading wire:target="profile_image" class="text-primary">
                    <small><i class="spinner-border spinner-border-sm me-1"></i>Uploading image...</small>
                </div>

                <!-- Error display -->
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['profile_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

        <!-- Personal Info -->
        <div class="row border-bottom mb-3">
            <div class="col-lg-6">
                <div class="row align-items-center mb-3">
                    <div class="col-lg-4">
                        <label class="form-label mb-0">Full Name <span class="text-danger ms-1">*</span></label>
                    </div>
                    <div class="col-lg-8">
                        <input type="text" class="form-control" wire:model="name">
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="row align-items-center mb-3">
                    <div class="col-lg-4">
                        <label class="form-label mb-0">Phone Number <span class="text-danger ms-1">*</span></label>
                    </div>
                    <div class="col-lg-8">
                        <input type="text" class="form-control" wire:model="phone_number">
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="row align-items-center mb-3">
                    <div class="col-lg-4">
                        <label class="form-label mb-0">Email</label>
                    </div>
                    <div class="col-lg-8">
                        <input type="email" class="form-control" value="<?php echo e(Auth::user()->email); ?>" readonly>
                        <small class="text-muted">Contact admin to change email</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="row align-items-center mb-3">
                    <div class="col-lg-4">
                        <label class="form-label mb-0">Specialization <span class="text-danger ms-1">*</span></label>
                    </div>
                    <div class="col-lg-8">
                        <input type="text" class="form-control" wire:model="specialization">
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['specialization'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="row align-items-center mb-3">
                    <div class="col-lg-4">
                        <label class="form-label mb-0">Years of Experience</label>
                    </div>
                    <div class="col-lg-8">
                        <input type="number" class="form-control" wire:model="years_of_experience" min="0"
                            max="50">
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['years_of_experience'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="row align-items-center mb-3">
                    <div class="col-lg-4">
                        <label class="form-label mb-0">License Number</label>
                    </div>
                    <div class="col-lg-8">
                        <input type="text" class="form-control" wire:model="license_number">
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>

        <!-- Bio -->
        <div class="row mb-3">
            <div class="col-lg-12">
                <div class="row mb-3">
                    <div class="col-lg-2">
                        <label class="form-label mb-0">Bio</label>
                    </div>
                    <div class="col-lg-10">
                        <textarea class="form-control" wire:model="bio" rows="4" maxlength="2000"></textarea>
                        <div class="d-flex justify-content-between mt-2">
                            <small class="text-muted">Maximum 2000 characters</small>
                            <small class="text-muted"><?php echo e(strlen($bio)); ?>/2000</small>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-end align-items-center gap-2">
            <button type="reset" class="btn btn-light btn-md fs-13 fw-medium rounded">Cancel</button>
            <button type="submit" class="btn btn-primary btn-md fs-13 fw-medium rounded">
                <span wire:loading.remove>Save Changes</span>
                <span wire:loading>Saving...</span>
            </button>
        </div>
    </form>
</div>
<?php /**PATH /var/www/predcare/resources/views/livewire/doctor/profile/doctor-basic-info-component.blade.php ENDPATH**/ ?>