<div class="content">
    <!-- Start Page Header -->
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 pb-3 mb-3 border-1 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">Patients List
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    Total Patients : <?php echo e($totalPatients); ?>

                </span>
            </h4>
        </div>
        <div class="text-end d-flex">
            <!-- Export Dropdown -->
            

            <!-- Add New Patient -->
            <a href="<?php echo e(route('admin.patient-management')); ?>" class="btn btn-primary ms-2 fs-13 btn-md">
                <i class="ti ti-plus me-1"></i>New Patient
            </a>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Start Filter -->
    <div class="d-flex align-items-center justify-content-between flex-wrap">
        <!-- Search -->
        <div>
            <div class="search-set mb-3">
                <div class="d-flex align-items-center flex-wrap gap-2">
                    <div class="table-search d-flex align-items-center mb-0">
                        <div class="search-input">
                            <input type="text" wire:model.live.debounce.300ms="searchTerm"
                                class="form-control form-control-md" placeholder="Search patients...">
                            <a href="javascript:void(0);" class="btn-searchset"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters and Sort -->
        <!-- Filters and Sort -->
        <div class="d-flex table-dropdown mb-3 right-content align-items-center flex-wrap row-gap-3">
            <!-- Filter Dropdown -->
            <div class="dropdown me-2">
                <a href="javascript:void(0);"
                    class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                    data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                </a>
                <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                    <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                        <h4 class="mb-0">Filter</h4>
                        <div class="d-flex align-items-center">
                            <a href="javascript:void(0);" wire:click="resetFilters"
                                class="link-danger text-decoration-underline">Clear All</a>
                        </div>
                    </div>
                    <form wire:submit.prevent="$refresh">
                        <div class="filter-body pb-0">
                            <!-- Status Filter -->
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Status</label>
                                    <a href="javascript:void(0);" wire:click="$set('statusFilter', 'all')"
                                        class="link-primary mb-1">Reset</a>
                                </div>
                                <select class="form-select" wire:model="statusFilter">
                                    <option value="all">All Statuses</option>
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>

                            <!-- Gender Filter -->
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Gender</label>
                                    <a href="javascript:void(0);" wire:click="$set('genderFilter', 'all')"
                                        class="link-primary mb-1">Reset</a>
                                </div>
                                <select class="form-select" wire:model="genderFilter">
                                    <option value="all">All Genders</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>

                            
                        </div>
                        <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                            <a href="javascript:void(0);" class="btn btn-light btn-md me-2" id="close-filter">Close</a>
                            <button type="submit" class="btn btn-primary btn-md">Apply</button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Keep your existing Sort Dropdown -->
            <div class="dropdown">
                <a href="javascript:void(0);"
                    class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                    data-bs-toggle="dropdown">
                    <span class="me-1">Sort By : </span> <?php echo e(ucfirst($sortBy)); ?>

                </a>
                <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('recent')">Recent</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('oldest')">Oldest</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <!-- End Filter -->

    <!-- Start Table -->
    <div class="table-responsive">
        <table class="table datatable table-nowrap">
            <thead class="">
                <tr>
                    <th>Patient</th>
                    <th>Phone</th>
                    
                    <th>Address</th>
                    <th>Last Visit</th>
                    <th>Status</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        // Get the most recent active patient clinic association
                        $patientClinic = $patient->patientClinics
                            ->where('status', 'active')
                            ->sortByDesc('created_at')
                            ->first();

                        $doctor = $patientClinic->doctor ?? null;
                        $lastVisit = $patientClinic ? $patientClinic->created_at->format('d M Y') : 'N/A';
                        $profileImage = $patient->patient->profile_image ?? null;
                        $initials = getInitials($patient->name);
                    ?>

                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <a href="<?php echo e(route('admin.patient-view', $patient->id)); ?>" class="avatar avatar-md me-2">
                                    <!--[if BLOCK]><![endif]--><?php if($profileImage && file_exists(public_path('storage/' . $profileImage))): ?>
                                        <img src="<?php echo e(asset('storage/' . $profileImage)); ?>" alt="<?php echo e($patient->name); ?>"
                                            class="rounded-circle">
                                    <?php else: ?>
                                        <div
                                            class="avatar-initial rounded-circle bg-primary text-white d-flex align-items-center justify-content-center fw-bold">
                                            <?php echo e($initials); ?>

                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </a>
                                <a href="<?php echo e(route('admin.patient-view', $patient->id)); ?>" class="text-dark fw-semibold">
                                    <?php echo e($patient->name); ?>

                                    <span class="text-body fs-13 fw-normal d-block">
                                        <?php echo e(ucfirst($patient->patient->gender ?? 'N/A')); ?>

                                    </span>
                                </a>
                            </div>
                        </td>
                        <td><?php echo e($patient->patient->phone ?? 'N/A'); ?></td>
                        
                        <td><?php echo e($patient->patient->address ?? 'N/A'); ?></td>
                        <td><?php echo e($lastVisit); ?></td>
                        <td>
                            <span
                                class="badge badge-soft-<?php echo e($patient->patient->status === 'active' ? 'success' : 'danger'); ?> rounded text-<?php echo e($patient->patient->status === 'active' ? 'success' : 'danger'); ?> border border-<?php echo e($patient->patient->status === 'active' ? 'success' : 'danger'); ?>">
                                <?php echo e(ucfirst($patient->patient->status)); ?>

                            </span>
                        </td>
                        <td>
                            <div class="d-flex align-items-center gap-1">
                                
                                <a href="javascript:void(0);"
                                    class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1"
                                    data-bs-toggle="dropdown">
                                    <i class="ti ti-dots-vertical"></i>
                                </a>
                                <ul class="dropdown-menu p-2 bg-white">
                                    <li>
                                        <a href="<?php echo e(route('admin.patient-management', ['edit_id' => $patient->id])); ?>"
                                            class="dropdown-item d-flex align-items-center"><i
                                                class="ti ti-edit me-2"></i>Edit</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.patient-view', $patient->id)); ?>"
                                            class="dropdown-item d-flex align-items-center"><i
                                                class="ti ti-eye me-2"></i>View</a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center"
                                            wire:click="toggleStatus(<?php echo e($patient->id); ?>)">
                                            <i class="ti ti-power me-2"></i>
                                            <?php echo e($patient->patient->status === 'active' ? 'Deactivate' : 'Activate'); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);"
                                            class="dropdown-item d-flex align-items-center text-danger"
                                            data-bs-toggle="modal" data-bs-target="#delete_patient"
                                            onclick="setDeletePatientId(<?php echo e($patient->id); ?>, '<?php echo e($patient->name); ?>')">
                                            <i class="ti ti-trash me-2"></i>Delete
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center">No patients found.</td>
                    </tr>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </tbody>
        </table>
    </div>
    <!-- End Table -->
    <?php if (isset($component)) { $__componentOriginal7a1de95135fea4b7a0f524148344a9f0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7a1de95135fea4b7a0f524148344a9f0 = $attributes; } ?>
<?php $component = App\View\Components\Table\Pagination::resolve(['paginator' => $patients,'position' => 'both'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('table.pagination'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Table\Pagination::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7a1de95135fea4b7a0f524148344a9f0)): ?>
<?php $attributes = $__attributesOriginal7a1de95135fea4b7a0f524148344a9f0; ?>
<?php unset($__attributesOriginal7a1de95135fea4b7a0f524148344a9f0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7a1de95135fea4b7a0f524148344a9f0)): ?>
<?php $component = $__componentOriginal7a1de95135fea4b7a0f524148344a9f0; ?>
<?php unset($__componentOriginal7a1de95135fea4b7a0f524148344a9f0); ?>
<?php endif; ?>

    <!-- Start Delete Modal -->
    <div class="modal fade" id="delete_patient">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-body text-center position-relative">
                    <img src="<?php echo e(asset('assets/img/bg/delete-modal-bg-01.png')); ?>" alt=""
                        class="img-fluid position-absolute top-0 start-0">

                    <img src="<?php echo e(asset('assets/img/bg/delete-modal-bg-02.png')); ?>" alt=""
                        class="img-fluid position-absolute bottom-0 end-0">

                    <div class="mb-3">
                        <span class="avatar avatar-lg bg-danger text-white"><i class="ti ti-trash fs-24"></i></span>
                    </div>
                    <h5 class="fw-bold mb-1">Delete Confirmation</h5>
                    <p class="mb-3">Are you sure you want to delete <strong id="patientName"></strong>?</p>
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btn btn-light position-relative z-1 me-3"
                            data-bs-dismiss="modal">Cancel</a>
                        <a href="javascript:void(0);" class="btn btn-danger position-relative z-1"
                            id="confirmDeleteBtn">Yes, Delete</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <style>
        .avatar-initial {
            width: 40px;
            height: 40px;
            font-size: 16px;
            font-weight: 600;
        }

        .avatar .avatar-initial {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        .avatar-initial.bg-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
        }

        .avatar-initial.bg-success {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%) !important;
        }

        .avatar-initial.bg-info {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%) !important;
        }

        .avatar-initial.bg-warning {
            background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%) !important;
        }

        .avatar-initial.bg-danger {
            background: linear-gradient(135deg, #fa709a 0%, #fee140 100%) !important;
        }

        .avatar-initial.bg-secondary {
            background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%) !important;
        }
    </style>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        let patientIdToDelete = null;

        function setDeletePatientId(patientId, patientName) {
            patientIdToDelete = patientId;
            document.getElementById('patientName').textContent = patientName;
        }

        document.getElementById('confirmDeleteBtn').addEventListener('click', function() {
            if (patientIdToDelete) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('deletePatient', patientIdToDelete);

                const modal = bootstrap.Modal.getInstance(document.getElementById('delete_patient'));
                modal.hide();

                patientIdToDelete = null;
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/predcare/resources/views/livewire/admin/patient/patient-list.blade.php ENDPATH**/ ?>