<!DOCTYPE html>
<html>
<head>
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Video Call</title>
  <!-- Prebuilt JS SDK (version may change) -->
  <script src="https://sdk.videosdk.live/rtc-js-prebuilt/0.3.37/rtc-js-prebuilt.js"></script>
  <style>
    body,html{height:100%;margin:0}
    #video-container{width:100%;height:100vh; background:#000}
  </style>
</head>
<body>
<div id="video-container"></div>

<script>
(async () => {
  try {
    // Fetch token from backend (protected route)
    const tokenRes = await fetch("{{ auth('doctor')->check() ? route('doctor.videosdk.token') : route('patient.videosdk.token') }}");
    const tokenJson = await tokenRes.json();
    if (tokenJson.status !== 'success' || !tokenJson.token) {
      alert('Unable to get token');
      return;
    }

    const config = {
      name: "{{ $user->name ?? 'User' }}",
      meetingId: "{{ $meetingId }}",
      apiKey: "{{ env('VIDEOSDK_API_KEY') }}", // some SDKs require apiKey + token
      token: tokenJson.token,
      containerId: "video-container",
      micEnabled: true,
      webcamEnabled: true,
      participantCanToggleSelfWebcam: true,
      participantCanToggleSelfMic: true,
      participantCanLeave: true,
      // When leave is pressed, SDK will redirect to redirectOnLeave
      redirectOnLeave: "{{ auth('doctor')->check() ? route('doctor.call', ['appointment_id' => $appointment->id]) : route('patient.call', ['appointment_id' => $appointment->id]) }}",
    };

    const meeting = new VideoSDKMeeting();
    meeting.init(config);

    // Optional: notify server when user leaves (best-effort)
    window.addEventListener('beforeunload', async () => {
      try {
        await navigator.sendBeacon('/api/end-appointment-meeting', JSON.stringify({
          appointment_id: {{ $appointment->id }}
        }));
      } catch(e) {}
    });

    // If you want to explicitly call end API when meeting ended via SDK events (if SDK exposes event):
    // meeting.on('left-meeting', async () => { await fetch('/api/end-appointment-meeting', {method:'POST',...}) });

  } catch (err) {
    console.error(err);
    alert('Failed to join meeting');
  }
})();
</script>
</body>
</html>
