@extends('layouts.app')

@section('title', 'Patient Dashboard')

@section('content')
    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Page Header -->
        <div class="d-flex align-items-sm-center justify-content-between flex-wrap gap-2 mb-4">
            <div>
                <h4 class="fw-bold mb-0">Patient Dashboard</h4>
            </div>
            <div class="d-flex align-items-center flex-wrap gap-2">
                <a href="{{ route('patient.appointments.create') }}" class="btn btn-primary d-inline-flex align-items-center">
                    <i class="ti ti-plus me-1"></i>New Appointment</a>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- row start -->
        <div class="row">

            <!-- col start -->
            <div class="col-xl-3 col-md-6 d-flex">
                <div class="card flex-fill w-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-4">
                            <span class="avatar bg-primary rounded-circle fs-20 d-inline-flex flex-shrink-0"><i
                                    class="ti ti-calendar-heart"></i></span>
                            <div class="ms-2">
                                <p class="mb-1 text-truncate">Total Appointments</p>
                                <h3 class="fw-bold mb-0">{{ $totalAppointments }}</h3>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <div id="s-col-5" class="chart-set"></div>
                            <!-- <span class="badge fw-medium bg-success flex-shrink-0 me-2">+95%</span>
                            <p class="fs-13 mb-0">in last 7 Days </p> -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start -->
            <div class="col-xl-3 col-md-6 d-flex">
                <div class="card flex-fill w-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-4">
                            <span class="avatar bg-danger rounded-circle fs-20 d-inline-flex flex-shrink-0"><i
                                    class="ti ti-calendar-time"></i></span>
                            <div class="ms-2">
                                <p class="mb-1 text-truncate">Cancelled Appointments</p>
                                <h3 class="fw-bold mb-0">{{ $totalCancelledAppointments }}</h3>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <div id="s-col-6" class="chart-set"></div>
                            <!-- <span class="badge fw-medium bg-danger flex-shrink-0 me-2">-15%</span>
                            <p class="fs-13 mb-0">in last 7 Days</p> -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start -->
            <div class="col-xl-3 col-md-6 d-flex">
                <div class="card flex-fill w-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-4">
                            <span class="avatar bg-success rounded-circle fs-20 d-inline-flex flex-shrink-0"><i
                                    class="ti ti-stethoscope"></i></span>
                            <div class="ms-2">
                                <p class="mb-1 text-truncate">My Doctors</p>
                                <h3 class="fw-bold mb-0">{{ $totalDoctors }}</h3>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <div id="s-col-7" class="chart-set"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start -->
            <div class="col-xl-3 col-md-6 d-flex">
                <div class="card flex-fill w-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-4">
                            <span class="avatar bg-warning rounded-circle fs-20 d-inline-flex flex-shrink-0">
                                <i class="ti ti-report-money"></i>
                            </span>
                            <div class="ms-2">
                                <p class="mb-1 text-truncate">Total Transactions</p>
                                <h3 class="fw-bold mb-0">₹ {{ $totalTransactions }}</h3>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <div id="s-col-9" class="chart-set"></div>
                            <!-- Optional: <span class="badge fw-medium bg-success flex-shrink-0 me-2">+12%</span>
                            <p class="fs-13 mb-0">vs last 7 days</p> -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- col end -->

        </div>
        <!-- row start -->

        <!-- row start -->
        <div class="row">

            <!-- col start -->
            <div class="col-xl-4 col-lg-6 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">My Doctors</h5>
                    </div>
                    <div class="card-body">
                        @foreach($myDoctors as $doctor)
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div class="d-flex align-items-center">
                                    <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                        <img src="{{ $doctor->profile_image ? asset('storage/' . $doctor->profile_image) : asset('assets/img/doctors/doctor-01.jpg') }}" 
                                            alt="Doctor Profile" class="rounded-circle object-fit-cover" width="40" height="40">
                                    </a>
                                    <div>
                                        <h6 class="fs-14 mb-1 text-truncate">
                                            <a href="javascript:void(0);" class="fw-semibold">
                                                Dr. {{ $doctor->doctor_name }}
                                            </a>
                                        </h6>
                                        <p class="mb-0 fs-13 text-truncate">{{ $doctor->specialization }}</p>
                                    </div>
                                </div>
                                <span class="badge fw-medium badge-soft-danger border border-danger flex-shrink-0">
                                    {{ $doctor->total_bookings }} Bookings
                                </span>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start -->
            <div class="col-xl-4 col-lg-6 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Prescriptions</h5>
                    </div>
                    <div class="card-body">
                        <div class="overflow-auto">
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div class="d-flex align-items-center flex-shrink-0">
                                    <a href="javascript:void(0);"
                                        class="avatar me-2 flex-shrink-0 bg-light rounded-circle text-dark">
                                        <i class="ti ti-file-description fs-20"></i>
                                    </a>
                                    <div>
                                        <h6 class="fs-14 mb-1 text-truncate"><a href="{{ route('patient.prescriptions.list') }}" class="fw-semibold">Cardiology Prescription</a></h6>
                                        <p class="mb-0 fs-13 text-truncate">20 Apr 2025</p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center">
                                    <a href="{{ route('patient.prescriptions.list') }}" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm me-2 p-1"><i class="ti ti-eye"></i></a>
                                </div>
                            </div>
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div class="d-flex align-items-center flex-shrink-0">
                                    <a href="javascript:void(0);"
                                        class="avatar me-2 flex-shrink-0 bg-light rounded-circle text-dark">
                                        <i class="ti ti-file-description fs-20"></i>
                                    </a>
                                    <div>
                                        <h6 class="fs-14 mb-1 text-truncate"><a href="{{ route('patient.prescriptions.list') }}" class="fw-semibold">Dentist Prescription</a></h6>
                                        <p class="mb-0 fs-13 text-truncate">25 Mar 2025</p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center">
                                    <a href="{{ route('patient.prescriptions.list') }}" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm me-2 p-1"><i class="ti ti-eye"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start -->
            <div class="col-xl-4 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Recent Transactions</h5>
                        <!-- <div class="dropdown">
                            <a href="javascript:void(0);"
                                class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"
                                data-bs-toggle="dropdown">
                                Weekly <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu bg-white">
                                <li>
                                    <a class="dropdown-item" href="#">Monthly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Weekly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Yearly</a>
                                </li>
                            </ul>
                        </div> -->
                    </div>
                    <div class="card-body">

                        <!-- Table start -->
                        <div class="table-responsive table-nowrap">
                            <table class="table">
                                <tbody>
                                    @foreach($recentTransactions as $transaction)
                                        <tr class="border-white">
                                            <td class="ps-0">
                                                <div class="d-flex align-items-center">
                                                    <a href="javascript:void(0);" class="avatar me-2">
                                                        <img src="{{ asset('storage/'.$transaction->doctor_image) }}" 
                                                            alt="img" class="rounded-circle" width="40" height="40">
                                                    </a>
                                                    <div>
                                                        <h6 class="fs-14 mb-1">
                                                            <a href="javascript:void(0);" class="fw-semibold">
                                                                Dr. {{ $transaction->doctor_name }}
                                                            </a>
                                                        </h6>
                                                        <p class="mb-0 fs-13">{{ $transaction->specialization }}</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                                <p class="fs-13">${{ number_format($transaction->appointment_fee, 2) }}</p>
                                            </td>
                                            <td class="pe-0 text-end">
                                                @php
                                                    $badgeClass = $transaction->appointment_status === 'completed' ? 'success' : 'danger';
                                                    $statusText = ucfirst(str_replace('_', ' ', $transaction->appointment_status));
                                                @endphp
                                                <span class="badge fs-13 py-1 badge-soft-{{ $badgeClass }} border border-{{ $badgeClass }} rounded text-{{ $badgeClass }} fw-medium">
                                                    {{ $statusText }}
                                                </span>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- Table end -->

                    </div>
                </div>
            </div>
            <!-- col end -->

        </div>
        <!-- row end -->

        <!-- card start --
        <div class="card shadow-sm">
            <div class="card-header">
                <h5 class="fw-bold mb-0">Vitals</h5>
            </div>
            <div class="card-body">

                <!-- row start --
                <div class="row row-gap-3 row-cols-1 row-cols-xl-6 row-cols-md-3 row-cols-sm-2">

                    <!-- col start --
                    <div class="col d-flex">
                        <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                            <div class="d-flex align-items-center">
                                <span class="avatar bg-primary rounded-circle flex-shrink-0"><img
                                        src="{{ asset('assets/img/icons/weight.svg') }}" alt="img"
                                        class="w-auto h-auto"></span>
                                <div class="ms-1">
                                    <p class="mb-1">Weight</p>
                                    <p class="text-truncate"><span class="fs-18 fw-bold text-dark">100</span> Kg</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start --
                    <div class="col d-flex">
                        <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                            <div class="d-flex align-items-center">
                                <span class="avatar bg-primary rounded-circle flex-shrink-0"><img
                                        src="{{ asset('assets/img/icons/rotate-left.svg') }}" alt="img"
                                        class="w-auto h-auto"></span>
                                <div class="ms-1">
                                    <p class="mb-1">Height</p>
                                    <p class="text-truncate"><span class="fs-18 fw-bold text-dark">154</span> Cm</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end --

                    <!-- col start --
                    <div class="col d-flex">
                        <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                            <div class="d-flex align-items-center">
                                <span class="avatar bg-primary rounded-circle flex-shrink-0"><img
                                        src="{{ asset('assets/img/icons/user-cirlce-add.svg') }}" alt="img"
                                        class="w-auto h-auto"></span>
                                <div class="ms-1">
                                    <p class="mb-1">BMI</p>
                                    <p class="text-truncate"><span class="fs-18 fw-bold text-dark">19.2</span> kg/cm</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start --
                    <div class="col d-flex">
                        <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                            <div class="d-flex align-items-center">
                                <span class="avatar bg-primary rounded-circle flex-shrink-0"><img
                                        src="{{ asset('assets/img/icons/driver-2.svg') }}" alt="img"
                                        class="w-auto h-auto"></span>
                                <div class="ms-1">
                                    <p class="mb-1">Pulse</p>
                                    <p class="text-truncate"><span class="fs-18 fw-bold text-dark">97%</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start --
                    <div class="col d-flex">
                        <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                            <div class="d-flex align-items-center">
                                <span class="avatar bg-primary rounded-circle flex-shrink-0"><img
                                        src="{{ asset('assets/img/icons/wind.svg') }}" alt="img"
                                        class="w-auto h-auto"></span>
                                <div class="ms-1">
                                    <p class="mb-1">SPO2</p>
                                    <p class="text-truncate"><span class="fs-18 fw-bold text-dark">98%</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end --

                    <!-- col start --
                    <div class="col d-flex">
                        <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                            <div class="d-flex align-items-center">
                                <span class="avatar bg-primary rounded-circle flex-shrink-0"><img
                                        src="{{ asset('assets/img/icons/sun.svg') }}" alt="img"
                                        class="w-auto h-auto"></span>
                                <div class="ms-1">
                                    <p class="mb-1 text-truncate">Temprature</p>
                                    <p class="text-truncate"><span class="fs-18 fw-bold text-dark">101</span> C</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end --

                </div>
                <!-- row end --

            </div>
        </div>
        <!-- card end -->

        <!-- row start --
        <div class="row">

            <!-- col start --
            <div class="col-lg-6 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Consultation By Department</h5>
                        <div class="dropdown">
                            <a href="javascript:void(0);"
                                class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"
                                data-bs-toggle="dropdown">
                                Monthly <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu bg-white">
                                <li>
                                    <a class="dropdown-item" href="#">Monthly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Weekly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Yearly</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <div id="s-col-10" class="chart-set"></div>
                    </div>
                </div>
            </div>
            <!-- col end -->

            <!-- col start --
            <div class="col-lg-6 d-flex">
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Recent Transactions</h5>
                        <div class="dropdown">
                            <a href="javascript:void(0);"
                                class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"
                                data-bs-toggle="dropdown">
                                Weekly <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu bg-white">
                                <li>
                                    <a class="dropdown-item" href="#">Monthly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Weekly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Yearly</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">

                        <!-- Table start --
                        <div class="table-responsive table-nowrap">
                            <table class="table">
                                <tbody>
                                    <tr class="border-white">
                                        <td class="ps-0">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:void(0);" class="avatar me-2">
                                                    <img src="{{ asset('assets/img/doctors/doctor-06.jpg') }}"
                                                        alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                    <h6 class="fs-14 mb-1"><a href="javascript:void(0);"
                                                            class="fw-semibold">Dr. John Smith</a></h6>
                                                    <p class="mb-0 fs-13">Neurosurgeon</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                            <p class="fs-13">$450</p>
                                        </td>
                                        <td class="pe-0 text-end"><span
                                                class="badge fs-13 py-1 badge-soft-success border border-success rounded text-success fw-medium">Success</span>
                                        </td>
                                    </tr>
                                    <tr class="border-white">
                                        <td class="ps-0">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:void(0);" class="avatar me-2">
                                                    <img src="{{ asset('assets/img/doctors/doctor-07.jpg') }}"
                                                        alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                    <h6 class="fs-14 mb-1"><a href="javascript:void(0);"
                                                            class="fw-semibold">Dr. Lisa White</a></h6>
                                                    <p class="mb-0 fs-13">Oncologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                            <p class="fs-13">$350</p>
                                        </td>
                                        <td class="pe-0 text-end"><span
                                                class="badge fs-13 py-1 badge-soft-success border border-success rounded text-success fw-medium">Success</span>
                                        </td>
                                    </tr>
                                    <tr class="border-white">
                                        <td class="ps-0">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:void(0);" class="avatar me-2">
                                                    <img src="{{ asset('assets/img/doctors/doctor-08.jpg') }}"
                                                        alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                    <h6 class="fs-14 mb-1"><a href="javascript:void(0);"
                                                            class="fw-semibold">Dr. Patricia Brown</a></h6>
                                                    <p class="mb-0 fs-13">Pulmonologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                            <p class="fs-13">$400</p>
                                        </td>
                                        <td class="pe-0 text-end"><span
                                                class="badge fs-13 py-1 badge-soft-danger border border-danger rounded text-danger fw-medium">Failed</span>
                                        </td>
                                    </tr>
                                    <tr class="border-white">
                                        <td class="ps-0">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:void(0);" class="avatar me-2">
                                                    <img src="{{ asset('assets/img/doctors/doctor-09.jpg') }}"
                                                        alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                    <h6 class="fs-14 mb-1"><a href="javascript:void(0);"
                                                            class="fw-semibold">Dr. Rachel Green</a></h6>
                                                    <p class="mb-0 fs-13">Urologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                            <p class="fs-13">$550</p>
                                        </td>
                                        <td class="pe-0 text-end"><span
                                                class="badge fs-13 py-1 badge-soft-success border border-success rounded text-success fw-medium">Success</span>
                                        </td>
                                    </tr>
                                    <tr class="border-white">
                                        <td class="ps-0">
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:void(0);" class="avatar me-2">
                                                    <img src="{{ asset('assets/img/doctors/doctor-10.jpg') }}"
                                                        alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                    <h6 class="fs-14 mb-1"><a href="javascript:void(0);"
                                                            class="fw-semibold">Dr. Michael Smith</a></h6>
                                                    <p class="mb-0 fs-13">Cardiologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                            <p class="fs-13">$600</p>
                                        </td>
                                        <td class="pe-0 text-end"><span
                                                class="badge fs-13 py-1 badge-soft-success border border-success rounded text-success fw-medium">Success</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- Table end --

                    </div>
                </div>
            </div>
            <!-- col end --

        </div>
        <!-- row end -->

        <!-- card start -->
        <div class="card shadow-sm flex-fill w-100">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="fw-bold mb-0">Recent Appointments</h5>
                <div class="dropdown">
                    <a href="javascript:void(0);"
                        class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"
                        data-bs-toggle="dropdown">
                        Weekly <i class="ti ti-chevron-down ms-1"></i>
                    </a>
                    <ul class="dropdown-menu bg-white">
                        <li>
                            <a class="dropdown-item" href="#">Monthly</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">Weekly</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">Yearly</a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <!-- Table start -->
                <div class="table-responsive table-nowrap">
                    <table class="table border">
                        <thead class="thead-light">
                            <tr>
                                <th>Auto ID</th>
                                <th>Appointment ID</th>
                                <th>Doctor</th>
                                <th>Specialization</th>
                                <th>Appointment Date</th>
                                <th>Appointment Time (Slot)</th>
                                <th>Consultation Fees</th>
                                <th>Appointment Type</th>
                                <th>Reason</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($appointments as $item)
                            <tr>
                                <td>{{ $item->id }}</td>
                                <td>{{ $item->appointment_id }}</td>
                                <td>{{ $item->doctor->name ?? 'N/A' }}</td>
                                <td>{{ $item->specialization }}</td>
                                <td>{{ \Carbon\Carbon::parse($item->appointment_date)->isoFormat('D, MMMM YYYY') }}</td>
                                <td>
                                    <ul class="list-unstyled mb-0">
                                        @foreach (json_decode($item->appointment_slot_time) as $slot)
                                            <li class="d-inline-block me-2 mb-2 px-3 border rounded bg-light">
                                                <i class="ti ti-clock me-1 text-primary"></i> {{ $slot }}
                                            </li><br>
                                        @endforeach
                                    </ul>
                                </td>
                                <td>
                                    <strong>
                                        @if ($item->fee_type === 'in_person_fee')
                                            In-Person
                                        @elseif ($item->fee_type === 'video_fee')
                                            Video
                                        @else
                                            {{ ucfirst(str_replace('_', ' ', $item->fee_type)) }}
                                        @endif
                                    </strong>
                                    - ${{ $item->appointment_fee }}
                                </td>
                                <td>
                                    @if ($item->appointment_type === 'first_visit')
                                        First Visit
                                    @elseif ($item->appointment_type === 'follow_up')
                                        Follow Up
                                    @else
                                        {{ ucfirst($item->appointment_type) }}
                                    @endif
                                </td>
                                <td>{{ $item->reason }}</td>
                                <td>
                                    {{-- Appointment Status --}}
                                    @if($item->appointment_status == 'completed')
                                        <span class="badge bg-success fw-medium">Completed</span>
                                    @elseif($item->appointment_status == 'cancelled')
                                        <span class="badge bg-danger fw-medium">Cancelled</span>
                                    @else
                                        @if ($item->fee_type === 'in_person_fee')
                                            
                                        @elseif ($item->fee_type === 'video_fee')
                                            <div class="">
                                                <a href="{{ route('patient.call', [
                                                                'appointment_id' => $item->appointment_id,
                                                                'doctor_id'      => auth('doctor')->id(),
                                                                'patient_id'     => $item->patient_id, // optional but nice
                                                            ]) }}"
                                                    class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2" data-bs-toggle="tooltip" title="Start Video Call">
                                                    <i class="ti ti-video"></i>
                                                </a>

                                                <!-- <a href="{{ route('patient.call') }}" class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14" data-bs-toggle="tooltip" title="Start Audio Call">
                                                    <i class="ti ti-phone"></i>
                                                </a> -->
                                                <!-- <a href="{{ route('patient.call') }}" class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14" data-bs-toggle="tooltip" title="Start Chat">
                                                    <i class="ti ti-message-circle"></i>
                                                </a> -->
                                            </div>
                                        @endif
                    
                                        <span class="badge bg-secondary fw-medium">{{ ucfirst($item->appointment_status) }}</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <!-- Table end -->
            </div>
        </div>
        <!-- card end -->

    </div>
    <!-- End Content -->
@endsection
