@extends('layouts.mail')

@section('title', 'Your Staff Account Has Been Created on PRED Care')

@section('content')
    <h2>Hi {{ $staffName }},</h2>
    <p>Welcome to PRED Care! You’ve been added as a staff member under {{ $clinicName }} / {{ $doctorName }}.</p>
    <h3>Login Details:</h3>
    <ul>
        <li><strong>Username:</strong> {{ $username }}</li>
        <li><strong>Temporary Password:</strong> {{ $temporaryPassword }}</li>
        <li><strong>Login URL:</strong> <a href="https://www.predcare.in/login">https://www.predcare.in/login</a></li>
    </ul>
    <p>⚠️ Please log in and change your password immediately to secure your account.</p>
    <p>You have been assigned the role of: <strong>{{ $role }}</strong></p>
    <p>Your access has been customized based on your responsibilities.</p>
    <h3>Quick Links:</h3>
    <ul>
        <li><a href="https://www.predcare.in/login">PRED Care Login</a></li>
        <li><a href="https://www.predcare.in/support">Help & Support</a></li>
        <li><a href="https://www.predcare.in/staff-guide">Staff User Guide</a></li>
    </ul>
    <p>For questions or issues, reach us at <a href="mailto:info@predcare.in">info@predcare.in</a></p>
    <p>Warm regards,<br>The PRED Care Team<br>
        Website: <a href="https://www.predcare.in">https://www.predcare.in</a></p>
@endsection
