<div class="d-flex flex-column justify-content-lg-center p-4 p-lg-0 pb-0 flex-fill">
    <div class=" mx-auto mb-3 text-center">
        <img src="{{ asset('assets/img/PRED_CARE-Logo.png') }}" class="img-fluid login-logo-small" alt="Logo">
    </div>
    <div class="card border-1 p-lg-3 shadow-md rounded-3 mb-4">
        <div class="card-body">
            <div class="text-center mb-3">
                <h5 class="mb-1 fs-20 fw-bold">Reset Password</h5>
                <p class="mb-0">Enter your new password to complete the reset process</p>
            </div>

            <input type="hidden" name="token" value="{{ $token }}">

            @if ($status)
                <div class="alert alert-{{ str_contains($status, 'successfully') ? 'success' : 'danger' }} mt-3">
                    {{ $status }}
                </div>
            @endif

            <div class="mb-3">
                <label class="form-label">New Password <span class="text-danger">*</span></label>
                <div class="position-relative">
                    <div class="pass-group input-group position-relative border rounded">
                        <span class="input-group-text bg-white border-0">
                            <i class="ti ti-lock text-dark fs-14"></i>
                        </span>
                        <input wire:model="password" type="password" name="password"
                            class="pass-input form-control ps-0 border-0" placeholder="Enter new password" 
                            wire:keydown.enter="resetPassword" required>
                        <span class="input-group-text bg-white border-0">
                            <i class="ti toggle-password ti-eye-off text-dark fs-14"></i>
                        </span>
                    </div>
                </div>
                @error('password')
                    <div class="text-danger pt-2">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="mb-3">
                <label class="form-label">Confirm Password <span class="text-danger">*</span></label>
                <div class="position-relative">
                    <div class="pass-group input-group position-relative border rounded">
                        <span class="input-group-text bg-white border-0">
                            <i class="ti ti-lock text-dark fs-14"></i>
                        </span>
                        <input wire:model="password_confirmation" type="password" name="password_confirmation"
                            class="pass-input form-control ps-0 border-0" placeholder="Confirm new password" 
                            wire:keydown.enter="resetPassword" required>
                        <span class="input-group-text bg-white border-0">
                            <i class="ti toggle-password ti-eye-off text-dark fs-14"></i>
                        </span>
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <button type="button"
                    class="btn bg-primary text-white w-100 position-relative d-flex align-items-center justify-content-center"
                    wire:click="resetPassword"
                    wire:loading.attr="disabled">

                    <span wire:loading.class="d-none">
                        <i class="fas fa-key me-2"></i>
                        Reset Password
                    </span>

                    <span wire:loading.class.remove="d-none" class="d-none">
                        <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                        Processing...
                    </span>
                </button>
            </div>
            
            <div class="text-center">
                <h6 class="fw-normal fs-14 text-dark mb-0">
                    Remember your password? 
                    <a href="{{ route('patient.login') }}" class="hover-a">
                        Back to Login
                    </a>
                </h6>
            </div>
        </div><!-- end card body -->
    </div><!-- end card -->
</div>

@script
    <script>
        Livewire.on('password-reset-success', () => {
            setTimeout(() => {
                window.location.href = "{{ route('home') }}";
            }, 2000);
        });
    </script>
@endscript