@php
    use App\Models\User;
    $isEditing = $staffId !== null;
@endphp

<div class="content">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="{{ route('doctor.staff.list') }}" class="text-dark">
                        <i class="ti ti-chevron-left me-1"></i>{{ $isEditing ? 'Edit Staff' : 'Add New Staff' }}
                    </a>
                </h6>
            </div>
            {{-- Messages --}}
            @if (session()->has('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if (session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <form wire:submit.prevent="save">
                <div class="card">
                    <div class="card-body">
                        <h6 class="fw-bold mb-3">Staff Information</h6>

                        <div class="row">
                            {{-- Profile Image --}}
                            <div class="col-lg-12 mb-4">
                                <div class="d-flex align-items-center">
                                    <label class="form-label mb-0 fw-medium">Profile Image</label>
                                    <div class="position-relative ms-4">
                                        <div
                                            class="drag-upload-btn avatar avatar-xxl rounded-circle bg-light text-muted position-relative overflow-hidden z-1 mb-2 p-0">
                                            @if ($profileImage)
                                                <img src="{{ $profileImage->temporaryUrl() }}" alt="Preview"
                                                    class="w-100 h-100 object-fit-cover rounded-circle">
                                            @elseif($currentProfileImage)
                                                <img src="{{ Storage::url($currentProfileImage) }}"
                                                    alt="Current Profile"
                                                    class="w-100 h-100 object-fit-cover rounded-circle">
                                            @else
                                                <i class="ti ti-user-plus fs-16"></i>
                                            @endif

                                            @unless ($staffId)
                                                <input type="file" wire:model="profileImage"
                                                    class="position-absolute top-0 start-0 w-100 h-100 opacity-0 cursor-pointer"
                                                    accept="image/*" x-data
                                                    x-on:change="
                                                            if ($el.files[0].size > 2097152) {
                                                                alert('File size must be less than 2MB');
                                                                $el.value = '';
                                                            }
                                                        ">

                                                <div
                                                    class="position-absolute bottom-0 end-0 start-0 w-100 h-25 bg-dark d-flex align-items-center justify-content-center z-n1">
                                                    <span class="text-white"><i class="ti ti-photo fs-14"></i></span>
                                                </div>
                                            @endunless
                                        </div>

                                        @unless ($staffId)
                                            @if ($profileImage || $currentProfileImage)
                                                <button type="button" wire:click="$set('profileImage', null)"
                                                    class="btn btn-sm btn-danger position-absolute top-0 end-0 rounded-circle p-1"
                                                    style="transform: translate(50%, -25%);">
                                                    <i class="ti ti-x fs-12"></i>
                                                </button>
                                            @endif
                                        @endunless
                                    </div>
                                </div>
                                @error('profileImage')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                                @unless ($staffId)
                                    <div wire:loading wire:target="profileImage" class="text-info small">
                                        <i class="spinner-border spinner-border-sm me-1"></i> Uploading image...
                                    </div>
                                @endunless
                            </div>

                            {{-- Supervising Doctor --}}
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Supervising Doctor <span class="text-danger">*</span></label>

                                <select class="form-select" wire:model="selectedDoctor"
                                    @if ($staffId) disabled @endif
                                    wire:key="doctor-select-{{ $selectedDoctor }}">
                                    <option value="" >Select Doctor</option>
                                    @foreach ($doctors as $doctor)
                                        <option value="{{ $doctor['id'] }}">{{ $doctor['name'] }}</option>
                                    @endforeach
                                </select>

                                @error('selectedDoctor')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>


                            {{-- Staff Mode --}}
                            @if (!$staffId)
                                <div class="mb-3 col-md-12">
                                    <label class="form-label d-block">Staff Selection Mode</label>
                                    <div class="form-check form-check-inline">
                                        <input type="radio" name="staffMode" class="form-check-input" id="createMode"
                                            wire:click="toggleStaffMode('create')" value="create"
                                            @checked($staffMode === 'create')>
                                        <label class="form-check-label" for="createMode">Create New Staff</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input type="radio" name="staffMode" class="form-check-input" id="selectMode"
                                            wire:click="toggleStaffMode('select')" value="select"
                                            @checked($staffMode === 'select')>
                                        <label class="form-check-label" for="selectMode">Select Existing Staff</label>
                                    </div>
                                </div>
                            @endif

                            {{-- Existing Staff Selection --}}
                            @if ($staffMode === 'select')
                                <div class="mb-3 col-md-6" x-data="{ dropdownOpen: @entangle('dropdownVisible') }">
                                    <label class="form-label">Select Staff Member <span
                                            class="text-danger">*</span></label>
                                    <div class="position-relative">
                                        <input type="text" class="form-control" placeholder="Search staff..."
                                            wire:model.live.debounce.300ms="searchTerm"
                                            @focus="$wire.set('dropdownVisible', true)"
                                            @click.away="$wire.set('dropdownVisible', false)">

                                        @if ($dropdownVisible && count($existingStaff) > 0)
                                            <div class="mt-1 dropdown-menu d-block position-absolute w-100 bg-white"
                                                style="z-index: 1000; max-height: 300px; overflow-y: auto;">
                                                @forelse($existingStaff as $staff)
                                                    <button type="button"
                                                        class="dropdown-item d-flex justify-content-between"
                                                        wire:click="selectStaff({{ $staff->id }})">
                                                        <span>{{ $staff->name }}</span>
                                                        <small class="text-muted">{{ $staff->email }}</small>
                                                    </button>
                                                @empty
                                                    <div class="dropdown-item text-muted">No staff found</div>
                                                @endforelse
                                            </div>
                                        @endif
                                    </div>

                                    @if ($selectedExistingStaff)
                                        @php
                                            $selectedStaff = \App\Models\User::find($selectedExistingStaff);
                                        @endphp
                                        <div
                                            class="p-2 mt-2 rounded bg-light d-flex justify-content-between align-items-center">
                                            <div>
                                                <strong>Selected:</strong> {{ $selectedStaff->name }}
                                                <br>
                                                <small class="text-muted">{{ $selectedStaff->email }}</small>
                                            </div>
                                            <button type="button" class="btn btn-sm btn-outline-danger"
                                                wire:click="$set('selectedExistingStaff', null)">
                                                <i class="fas fa-times"></i> Clear
                                            </button>
                                        </div>
                                    @endif

                                    @error('selectedExistingStaff')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            @endif

                            {{-- Name, Email, Phone (for create or edit) --}}
                            @if ($staffMode === 'create' || $staffId)
                                @if (!$staffId)
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="name">Full Name <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="name" wire:model="name" class="form-control"
                                            placeholder="John Doe"
                                            {{ $staffMode === 'select' && $selectedExistingStaff ? 'readonly' : '' }}>
                                        @error('name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="email">Email Address <span
                                                class="text-danger">*</span></label>
                                        <input type="email" id="email" wire:model="email" class="form-control"
                                            placeholder="example@email.com"
                                            {{ $staffMode === 'select' && $selectedExistingStaff ? 'readonly' : '' }}>
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="phone_number">Phone Number <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="phone_number" wire:model="phone_number"
                                            class="form-control" placeholder="+1234567890">
                                        @error('phone_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    {{-- Password fields only for create mode --}}

                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="password">
                                            Password
                                            @if ($staffId)
                                                <small class="text-muted">(Leave blank to keep current)</small>
                                            @else
                                                <span class="text-danger">*</span>
                                            @endif
                                        </label>
                                        <input type="password" id="password" wire:model="password"
                                            class="form-control"
                                            placeholder="{{ $staffId ? 'Leave blank to keep current' : 'Password' }}">
                                        @error('password')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="password_confirmation">Confirm Password</label>
                                        <input type="password" id="password_confirmation"
                                            wire:model="password_confirmation" class="form-control"
                                            placeholder="Confirm Password">
                                        @error('password_confirmation')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                @endif
                                @if ($staffId)
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="name">Full Name <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="name" wire:model="name" class="form-control"
                                            placeholder="John Doe" readonly>
                                        @error('name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="email">Email Address <span
                                                class="text-danger">*</span></label>
                                        <input type="email" id="email" wire:model="email" class="form-control"
                                            placeholder="example@email.com" readonly>
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                @endif
                            @endif

                            {{-- Permissions Section --}}
                            <div class="col-12 mt-4">
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="fw-bold mb-0">Staff Permissions</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive border">
                                            <table class="table table-nowrap">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th>Module</th>
                                                        <th>LIST</th>
                                                        <th>CREATE</th>
                                                        <th>EDIT</th>
                                                        <th>DELETE</th>
                                                        <th>VIEW</th>
                                                        <th>TOGGLE ALL</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($permissionGroups as $groupName => $groupPermissions)
                                                        @php
                                                            $allChecked =
                                                                count(
                                                                    array_intersect($groupPermissions, $permissions),
                                                                ) === count($groupPermissions) ||
                                                                $groupName === 'Dashboard Access';
                                                            $isDisabled = in_array($groupName, [
                                                                'Appointment Management',
                                                                'Medical Records',
                                                                'Financial',
                                                                'Staff Management',
                                                            ]);
                                                        @endphp
                                                        <tr>
                                                            <td>
                                                                <p class="fw-medium text-dark">{{ $groupName }}</p>
                                                            </td>
                                                            @php
                                                                $permissionTypes = [
                                                                    'list',
                                                                    'create',
                                                                    'edit',
                                                                    'delete',
                                                                    'view',
                                                                ];
                                                                $permissionColumns = [];

                                                                foreach ($permissionTypes as $type) {
                                                                    $permissionColumns[$type] = false;
                                                                    foreach ($groupPermissions as $permission) {
                                                                        if (str_contains($permission, $type)) {
                                                                            $permissionColumns[$type] = $permission;
                                                                            break;
                                                                        }
                                                                    }
                                                                }

                                                                if ($groupName === 'Dashboard Access') {
                                                                    $permissionColumns['view'] =
                                                                        'access admin dashboard';
                                                                }
                                                            @endphp

                                                            @foreach ($permissionTypes as $type)
                                                                <td>
                                                                    @if ($permissionColumns[$type])
                                                                        <div class="form-check form-check-md">
                                                                            <input class="form-check-input"
                                                                                type="checkbox"
                                                                                id="perm_{{ $permissionColumns[$type] }}"
                                                                                @checked(
                                                                                    $permissionColumns[$type] === 'access admin dashboard' ||
                                                                                        (is_array($permissions) && in_array($permissionColumns[$type], $permissions)))
                                                                                @disabled($permissionColumns[$type] === 'access admin dashboard' || $isDisabled)
                                                                                wire:click="togglePermission('{{ $permissionColumns[$type] }}')">
                                                                            @if ($permissionColumns[$type] === 'access admin dashboard')
                                                                                <span
                                                                                    class="text-muted">(Required)</span>
                                                                            @endif
                                                                        </div>
                                                                    @endif
                                                                </td>
                                                            @endforeach

                                                            <td>
                                                                <button type="button"
                                                                    class="btn btn-sm {{ $allChecked ? 'btn-outline-danger' : 'btn-outline-primary' }}"
                                                                    wire:click="toggleAllPermissionsInGroup('{{ $groupName }}')"
                                                                    @disabled($permissionColumns[$type] === 'access admin dashboard' || $isDisabled)>
                                                                    {{ $allChecked ? 'Deny All' : 'Allow All' }}
                                                                </button>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- Status --}}
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Status <span class="text-danger">*</span></label>
                                <div class="mt-2">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="status"
                                            id="statusActive" value="active" @if (!$staffId) disabled @endif>
                                        <label class="form-check-label" for="statusActive">Active</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="status"
                                            id="statusInactive" value="inactive" @if (!$staffId) selected disabled @endif>
                                        <label class="form-check-label" for="statusInactive">Inactive</label>
                                    </div>
                                </div>
                                @error('status')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            {{-- Notes --}}
                            <div class="mb-3 col-md-12">
                                <label class="form-label" for="notes">Additional Notes</label>
                                <textarea id="notes" wire:model="notes" class="form-control" rows="2"
                                    placeholder="Any additional notes about this staff member..."></textarea>
                                @error('notes')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            {{-- Password Note for new staff --}}
                            @if ($staffMode === 'create' && !$staffId)
                                <div class="col-md-12">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i>
                                        <strong>Note:</strong> A password is required for new staff. They can change it
                                        later through their profile.
                                    </div>
                                </div>
                            @endif

                            {{-- Assignment Note for existing users --}}
                            @if ($staffMode === 'select' && !$staffId)
                                <div class="col-md-12">
                                    <div class="alert alert-warning">
                                        <i class="fas fa-exclamation-triangle"></i>
                                        <strong>Note:</strong> This will assign the selected user as staff to the chosen
                                        clinic and doctor. They will receive an email notification.
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>

                    {{-- Form Actions --}}
                    <div class="card-footer text-end">
                        <button type="button" wire:click="resetForm" class="btn btn-secondary me-2">
                            <i class="ti ti-refresh"></i> Reset
                        </button>
                        <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                            <span wire:loading.remove>
                                @if ($staffId)
                                    <i class="ti ti-device-floppy"></i> Update Staff
                                @elseif ($staffMode === 'select')
                                    <i class="ti ti-user-plus"></i> Assign as Staff
                                @else
                                    <i class="ti ti-plus"></i> Add Staff
                                @endif
                            </span>
                            <span wire:loading>
                                <i class="ti ti-loader fa-spin"></i> Processing...
                            </span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
    <script>
        document.addEventListener('livewire:initialized', () => {
            Livewire.on('scroll-to-form', () => {
                document.getElementById('staff-form').scrollIntoView({
                    behavior: 'smooth'
                });
            });

            // Handle clicking outside dropdown to close it
            document.addEventListener('click', function(event) {
                const dropdown = document.querySelector('.dropdown-menu');
                const input = document.querySelector('input[placeholder="Search staff..."]');

                if (dropdown && input && !dropdown.contains(event.target) && !input.contains(event
                        .target)) {
                    @this.set('dropdownVisible', false);
                }
            });
        });
    </script>
@endpush
