<div>
    <h5 class="fw-bold pb-3 mb-4 border-1 border-bottom">Education Information</h5>

    @if(session()->has('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif

    <form wire:submit.prevent="save">
        @foreach($educations as $index => $education)
        <div class="education-entry border rounded p-3 mb-3 position-relative" >
            @if($index > 0)
            <button type="button" wire:click="removeEducation({{ $index }})" 
                    class="btn btn-sm btn-outline-danger position-absolute top-0 end-0 mt-2 me-2">
                <i class="fa fa-times"></i>
            </button>
            @endif

            <div class="row g-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="form-label fw-bold">Institution <span class="text-danger">*</span></label>
                        <input wire:model="educations.{{ $index }}.institution" type="text" 
                               class="form-control @error('educations.'.$index.'.institution') is-invalid @enderror" 
                               placeholder="University/College name">
                        @error('educations.'.$index.'.institution')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="form-label fw-bold">Degree <span class="text-danger">*</span></label>
                        <input wire:model="educations.{{ $index }}.degree" type="text" 
                               class="form-control @error('educations.'.$index.'.degree') is-invalid @enderror" 
                               placeholder="e.g., MBBS, MD, MS">
                        @error('educations.'.$index.'.degree')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="form-label fw-bold">Start Year <span class="text-danger">*</span></label>
                        <input wire:model="educations.{{ $index }}.start_year" type="number" min="1900" 
                               max="{{ date('Y') + 1 }}" 
                               class="form-control @error('educations.'.$index.'.start_year') is-invalid @enderror" 
                               placeholder="{{ date('Y') }}">
                        @error('educations.'.$index.'.start_year')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="form-label fw-bold">End Year</label>
                        <input wire:model="educations.{{ $index }}.end_year" type="number" min="1900" 
                               max="{{ date('Y') + 1 }}" 
                               class="form-control @error('educations.'.$index.'.end_year') is-invalid @enderror" 
                               placeholder="Leave empty if currently pursuing">
                        @error('educations.'.$index.'.end_year')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
        @endforeach

        <div class="d-flex justify-content-between align-items-center mb-4">
            <button type="button" wire:click="addEducation" class="btn btn-outline-primary">
                <i class="fa fa-plus me-1"></i> Add Education
            </button>
            
            <div>
                <button type="reset" class="btn btn-light btn-md fs-13 fw-medium rounded me-2">Cancel</button>
                <button type="submit" class="btn btn-primary btn-md fs-13 fw-medium rounded">
                    <span wire:loading.remove>Save Changes</span>
                    <span wire:loading>Saving...</span>
                </button>
            </div>
        </div>
    </form>
</div>