<div>
    <h5 class="fw-bold pb-3 mb-4 border-1 border-bottom">Certificates</h5>

    @if(session()->has('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif

    <form wire:submit.prevent="save">
        <div class="card border-0 shadow mb-4">
            <div class="card-header bg-primary text-light">
                <h5 class="mb-0 text-light"><i class="fas fa-certificate me-2"></i>Upload New Certificates</h5>
            </div>
            <div class="card-body p-4">
                <div class="form-group mb-4">
                    <input type="file" wire:model="tempCertificates" multiple 
                           accept=".pdf,.jpg,.jpeg,.png"
                           class="form-control @error('tempCertificates.*') is-invalid @enderror">
                    <small class="text-muted mt-2 d-block">
                        <i class="fas fa-info-circle me-1"></i>
                        Accepted formats: PDF, JPG, PNG (Maximum 5MB each)
                    </small>
                    @error('tempCertificates.*') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                @if(!empty($tempCertificates))
                    <div class="mb-4 p-3 bg-light rounded">
                        <h6 class="text-success mb-3">
                            <i class="fas fa-upload me-2"></i>Files Ready to Upload:
                        </h6>
                        <div class="row">
                            @foreach($tempCertificates as $file)
                                <div class="col-md-6 mb-2">
                                    <div class="d-flex align-items-center p-2 border rounded bg-white">
                                        <i class="fas @if (Str::endsWith($file->getClientOriginalName(), ['.jpg', '.jpeg', '.png', '.gif'])) fa-image text-primary @else fa-file-pdf text-danger @endif me-2"></i>
                                        <small class="text-truncate">{{ $file->getClientOriginalName() }}</small>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>

        @if(!empty($uploadedCertificates))
            <div class="card border-0 shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-folder-open me-2"></i>Uploaded Certificates</h5>
                </div>
                <div class="card-body p-4">
                    <div class="row">
                        @foreach($uploadedCertificates as $index => $certificate)
                            <div class="col-md-6 mb-3">
                                <div class="card border-success">
                                    <div class="card-body p-3">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <i class="fas @if (Str::endsWith($certificate['name'], ['.jpg', '.jpeg', '.png', '.gif'])) fa-image text-primary @else fa-file-pdf text-danger @endif me-2"></i>
                                                <small class="fw-bold">{{ $certificate['name'] }}</small>
                                                <br>
                                                <small class="text-muted">{{ \Carbon\Carbon::parse($certificate['uploaded_at'])->diffForHumans() }}</small>
                                            </div>
                                            <button type="button" wire:click="removeCertificate({{ $index }})" 
                                                    class="btn btn-sm btn-outline-danger">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif

        <div class="d-flex justify-content-end align-items-center gap-2">
            <button type="reset" class="btn btn-light btn-md fs-13 fw-medium rounded">Cancel</button>
            <button type="submit" class="btn btn-primary btn-md fs-13 fw-medium rounded">
                <span wire:loading.remove>Save Changes</span>
                <span wire:loading>Saving...</span>
            </button>
        </div>
    </form>
</div>