<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title">Doctor Clinic Management</h4>
                    <button wire:click="showAddForm" class="btn btn-primary" {{ !$doctorId ? 'disabled' : '' }}>
                        <i class="fas fa-plus"></i> Add Clinic Association
                    </button>
                </div>

                <div class="card-body">
                    @if (session()->has('message'))
                        <div class="alert alert-success alert-dismissible fade show">
                            {{ session('message') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if (session()->has('error'))
                        <div class="alert alert-danger alert-dismissible fade show">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <!-- Doctor Selection -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5><i class="fas fa-user-md"></i> Select Doctor</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <label for="selectedDoctorId" class="form-label">Choose Doctor *</label>
                                    <select wire:model.live="selectedDoctorId" class="form-select">
                                        <option value="">Select a doctor...</option>
                                        @foreach ($doctors as $doctorOption)
                                            <option value="{{ $doctorOption->id }}">
                                                {{ $doctorOption->name }} 
                                                @if($doctorOption->email)
                                                    ({{ $doctorOption->email }})
                                                @endif
                                                @if($doctorOption->getRoleNames()->isNotEmpty())
                                                    - {{ $doctorOption->getRoleNames()->first() }}
                                                @endif
                                            </option>
                                        @endforeach
                                    </select>
                                    @if($doctors->isEmpty())
                                        <small class="text-muted">No doctors found. Please ensure users have doctor roles assigned.</small>
                                    @endif
                                </div>
                            </div>
                            
                            @if($doctor)
                                <div class="mt-3 p-3 bg-light rounded">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <h6><i class="fas fa-user-circle"></i> Selected Doctor:</h6>
                                            <strong>{{ $doctor->name }}</strong><br>
                                            <small class="text-muted">
                                                {{ $doctor->email }}
                                                @if($doctor->getRoleNames()->isNotEmpty())
                                                    | Role: {{ $doctor->getRoleNames()->implode(', ') }}
                                                @endif
                                            </small>
                                        </div>
                                        <div class="col-md-4 text-end">
                                            <span class="badge bg-info">
                                                {{ $doctorAssociations->count() }} Clinic(s) Associated
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>

                    @if(!$doctorId)
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> Please select a doctor to manage their clinic associations.
                        </div>
                    @endif

                    @if($doctorId)
                        <!-- Add/Edit Form -->
                        @if ($showForm)
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5>
                                        <i class="fas fa-{{ $editingAssociationId ? 'edit' : 'plus' }}"></i>
                                        {{ $editingAssociationId ? 'Edit' : 'Add' }} Clinic Association for {{ $doctor->name }}
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <form wire:submit.prevent="save">
                                        <div class="row">
                                            <!-- Clinic Selection -->
                                            <div class="col-md-6 mb-3">
                                                <label for="selectedClinicId" class="form-label">Select Clinic *</label>
                                                <select wire:model="selectedClinicId" class="form-select @error('selectedClinicId') is-invalid @enderror" {{ $editingAssociationId ? 'disabled' : '' }}>
                                                    <option value="">Choose a clinic...</option>
                                                    @if($editingAssociationId)
                                                        @php
                                                            $currentClinic = App\Models\Clinic::find($selectedClinicId);
                                                        @endphp
                                                        @if($currentClinic)
                                                            <option value="{{ $currentClinic->id }}" selected>{{ $currentClinic->name }}</option>
                                                        @endif
                                                    @else
                                                        @foreach ($availableClinics as $clinic)
                                                            <option value="{{ $clinic->id }}">{{ $clinic->name }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                                @error('selectedClinicId') 
                                                    <div class="invalid-feedback">{{ $message }}</div> 
                                                @enderror
                                                @if($availableClinics->isEmpty() && !$editingAssociationId)
                                                    <small class="text-muted">All available clinics are already associated with this doctor.</small>
                                                @endif
                                            </div>

                                            <!-- Status -->
                                            <div class="col-md-6 mb-3">
                                                <label for="status" class="form-label">Status</label>
                                                <select wire:model="status" class="form-select">
                                                    <option value="active">Active</option>
                                                    <option value="inactive">Inactive</option>
                                                    <option value="suspended">Suspended</option>
                                                </select>
                                            </div>
                                        </div>

                                        <!-- Primary Status -->
                                        <div class="row">
                                            <div class="col-12 mb-3">
                                                <div class="form-check">
                                                    <input wire:model="isPrimary" class="form-check-input" type="checkbox" id="isPrimary">
                                                    <label class="form-check-label" for="isPrimary">
                                                        <strong>Set as Primary Clinic</strong>
                                                        <small class="text-muted d-block">Only one clinic can be set as primary for each doctor</small>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Consultation Fees -->
                                        <div class="row">
                                            <div class="col-12 mb-2">
                                                <h6 class="text-muted">Consultation Fees (Optional)</h6>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label for="inPersonFee" class="form-label">In-Person Consultation Fee</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input wire:model="inPersonFee" type="number" step="0.01" class="form-control @error('inPersonFee') is-invalid @enderror" placeholder="0.00">
                                                    @error('inPersonFee') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                                </div>
                                            </div>

                                            <div class="col-md-4 mb-3">
                                                <label for="videoFee" class="form-label">Video Consultation Fee</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input wire:model="videoFee" type="number" step="0.01" class="form-control @error('videoFee') is-invalid @enderror" placeholder="0.00">
                                                    @error('videoFee') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                                </div>
                                            </div>

                                            <div class="col-md-4 mb-3">
                                                <label for="homeVisitFee" class="form-label">Home Visit Fee</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input wire:model="homeVisitFee" type="number" step="0.01" class="form-control @error('homeVisitFee') is-invalid @enderror" placeholder="0.00">
                                                    @error('homeVisitFee') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                                </div>
                                            </div>
                                        </div>

                                        <div class="d-flex gap-2">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-save"></i>
                                                {{ $editingAssociationId ? 'Update' : 'Add' }} Association
                                            </button>
                                            <button type="button" wire:click="cancel" class="btn btn-secondary">
                                                <i class="fas fa-times"></i> Cancel
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        @endif

                        <!-- Current Associations Table -->
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead class="table-dark">
                                    <tr>
                                        <th><i class="fas fa-hospital"></i> Clinic Name</th>
                                        <th><i class="fas fa-toggle-on"></i> Status</th>
                                        <th><i class="fas fa-star"></i> Primary</th>
                                        <th><i class="fas fa-dollar-sign"></i> Consultation Fees</th>
                                        <th><i class="fas fa-cogs"></i> Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($doctorAssociations as $association)
                                        <tr>
                                            <td>
                                                <strong>{{ $association->clinic->name }}</strong>
                                                <br>
                                                <small class="text-muted">
                                                    <i class="fas fa-map-marker-alt"></i>
                                                    {{ $association->clinic->city }}, {{ $association->clinic->state }}
                                                </small>
                                            </td>
                                            <td>
                                                <span class="badge bg-{{ $association->status === 'active' ? 'success' : ($association->status === 'inactive' ? 'secondary' : 'warning') }}">
                                                    {{ ucfirst($association->status) }}
                                                </span>
                                            </td>
                                            <td>
                                                @if ($association->is_primary)
                                                    <span class="badge bg-primary">
                                                        <i class="fas fa-star"></i> Primary
                                                    </span>
                                                @else
                                                    <button wire:click="setPrimary({{ $association->id }})" 
                                                            class="btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-star"></i> Set Primary
                                                    </button>
                                                @endif
                                            </td>
                                            <td>
                                                <small>
                                                    @if ($association->in_person_fee)
                                                        <span class="badge bg-light text-dark me-1">In-Person: ${{ number_format($association->in_person_fee, 2) }}</span><br>
                                                    @endif
                                                    @if ($association->video_fee)
                                                        <span class="badge bg-light text-dark me-1">Video: ${{ number_format($association->video_fee, 2) }}</span><br>
                                                    @endif
                                                    @if ($association->home_visit_fee)
                                                        <span class="badge bg-light text-dark me-1">Home Visit: ${{ number_format($association->home_visit_fee, 2) }}</span>
                                                    @endif
                                                    @if (!$association->in_person_fee && !$association->video_fee && !$association->home_visit_fee)
                                                        <span class="text-muted">No fees set</span>
                                                    @endif
                                                </small>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <button wire:click="editAssociation({{ $association->id }})" 
                                                            class="btn btn-sm btn-outline-primary"
                                                            title="Edit Association">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <button wire:click="removeAssociation({{ $association->id }})" 
                                                            class="btn btn-sm btn-outline-danger"
                                                            title="Remove Association"
                                                            onclick="return confirm('Are you sure you want to remove this clinic association?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center text-muted py-4">
                                                <i class="fas fa-hospital fa-3x mb-3 opacity-50"></i><br>
                                                <h6>No clinic associations found for this doctor</h6>
                                                <small>Click "Add Clinic Association" to get started.</small>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>