<div class="content">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="{{ route('admin.subscription-plans.list') }}" class="text-dark">
                        <i class="ti ti-chevron-left me-1"></i>{{ isset($editingPlanId) ? 'Edit Plan' : 'Add Plan' }}
                    </a>
                </h6>
            </div>

            @if (session()->has('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @php
                $steps = [
                    1 => 'Plan Details',
                    2 => 'Plan Limits',
                    3 => 'Plan Features',
                    4 => 'Usage Rates',
                    5 => 'Review & Save',
                ];
            @endphp

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div
                            class="card-header d-flex justify-content-between align-items-center border-bottom border-dashed">
                            <h4 class="header-title">{{ $isEditing ? 'Edit' : 'Create' }} Subscription Plan</h4>
                        </div>
                        <div class="card-body">
                            <div id="progressbarwizard">
                                <ul class="nav nav-pills nav-justified form-wizard-header mb-3">
                                    @foreach ($steps as $stepNumber => $stepLabel)
                                        <li class="nav-item">
                                            <a href="#step-{{ $stepNumber }}" data-bs-toggle="tab" data-toggle="tab"
                                                class="nav-link rounded-0 py-2 {{ $currentStep == $stepNumber ? 'active' : '' }} {{ !$isEditing && $stepNumber > $highestStep ? 'disabled' : '' }}"
                                                wire:click.prevent="goToStep({{ $stepNumber }})">
                                                <span class="d-none d-sm-inline">{{ $stepLabel }}</span>
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>

                                <div class="tab-content b-0 mb-0">
                                    <div id="bar" class="progress mb-3" style="height: 7px;">
                                        <div class="bar progress-bar progress-bar-striped progress-bar-animated bg-primary"
                                            style="width: {{ (($currentStep - 1) / (count($steps) - 1)) * 100 }}%">
                                        </div>
                                    </div>

                                    <!-- Step Content -->
                                    <div class="tab-pane active">
                                        @if ($currentStep == 1)
                                            <livewire:admin.subscription-plan-wizard.step1-plan-details
                                                :data="[
                                                    'basic' => $planData['basic'] ?? [],
                                                    'combo' => $planData['is_combo'] ?? [],
                                                ]" :editingPlanId="$editingPlanId" :key="'step1-' . $editingPlanId" />
                                        @elseif($currentStep == 2)
                                            <livewire:admin.subscription-plan-wizard.step2-plan-limits :data="$planData['limits'] ?? []"
                                                :basic="$planData['basic']" :rates="$planData['rates']" :currency="$planData['basic']['currency'] ?? 'INR'"
                                                :key="'step2-' . $editingPlanId" />
                                        @elseif($currentStep == 3)
                                            <livewire:admin.subscription-plan-wizard.step3-plan-features
                                                :data="$planData['features'] ?? []" :isEditing="!!$editingPlanId" :currency="$planData['basic']['currency'] ?? 'INR'"
                                                :key="'step3-' . $editingPlanId" />
                                        @elseif($currentStep == 4)
                                            <livewire:admin.subscription-plan-wizard.step4-usage-rates
                                                :data="$planData['rates'] ?? []" :currency="$planData['basic']['currency'] ?? 'INR'" :key="'step4-' . $editingPlanId" />
                                        @elseif($currentStep == 5)
                                            <livewire:admin.subscription-plan-wizard.step5-review :planData="$planData"
                                                :isEditing="!!$editingPlanId" :key="'step5-' . $editingPlanId" />
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@push('scripts')
    <script src="{{ asset('assets/js/form-wizard.js') }}"></script>
@endpush
