<div class="card">
    <div class="card-header">
        <h5>Review Plan Details</h5>
        <p class="mb-0 text-muted">Please review all information before submitting</p>
    </div>
    <div class="card-body">
        <!-- Basic Information -->
        <div class="mb-5">
            <h6 class="border-bottom pb-2 mb-3">Basic Information</h6>
            <div class="row">
                <div class="col-md-4">
                    <p><strong>Plan Code:</strong> {{ $planData['basic']['plan_code'] ?? 'N/A' }}</p>
                </div>
                <div class="col-md-4">
                    <p><strong>Plan Name:</strong> {{ $planData['basic']['plan_name'] ?? 'N/A' }}</p>
                </div>
                <div class="col-md-4">
                    <p><strong>Plan Type:</strong> {{ ucfirst($planData['basic']['plan_type'] ?? 'N/A') }}</p>
                </div>
                <div class="col-md-4">
                    <p><strong>Duration:</strong> {{ $planData['basic']['duration'] ?? 'N/A' }}
                        {{ ($planData['basic']['plan_type'] ?? '') === 'monthly' ? 'Month(s)' : 'Year(s)' }}</p>
                </div>
                <div class="col-md-4">
                    <p><strong>Base Price:</strong> {{ $planData['basic']['currency'] ?? 'N/A' }}
                        {{ number_format($planData['basic']['base_price'] ?? 0, 2) }}</p>
                </div>
                <div class="col-md-4">
                    <p><strong>Status:</strong> {{ ucfirst($planData['basic']['plan_status'] ?? 'N/A') }}</p>
                </div>
            </div>
        </div>
        <!-- Plan Limits -->
        <div class="mb-5">
            <h6 class="border-bottom pb-2 mb-3">Plan Limits</h6>
            <div class="row">
                <div class="col-md-4">
                    <p><strong>Max Doctors:</strong> {{ $planData['limits']['included_doctors'] ?? 'N/A' }}</p>
                </div>
                <div class="col-md-4">
                    <p><strong>Additional Doctor Price:</strong> {{ $planData['basic']['currency'] ?? 'N/A' }}
                        {{ number_format($planData['limits']['additional_doctor_price'] ?? 0, 2) }}</p>
                </div>
                <div class="col-md-4">
                </div>
                <div class="col-md-4">
                    <p><strong>Max Staff:</strong> {{ $planData['limits']['included_staff'] ?? 'N/A' }}</p>
                </div>
                <div class="col-md-4">
                    <p><strong>Storage Limit:</strong> {{ $planData['limits']['storage_limit_gb'] ?? 'N/A' }} GB</p>
                </div>
                <div class="col-md-4">
                    <p><strong>Teleconsultation:</strong> {{ $planData['limits']['teleconsultation_minutes'] ?? 'N/A' }}
                        minutes</p>
                </div>
            </div>
        </div>
        <!-- Included Features -->
        <div class="mb-5">
            <h6 class="border-bottom pb-2 mb-3">Included Features ({{ count($planData['features'] ?? []) }})</h6>
            <div class="row">
                @foreach ($available_features as $feature)
                    <div class="col-md-4 mb-2">
                        <i class="fas fa-check-circle text-success me-2"></i>
                        {{ $feature->feature_name }}
                    </div>
                @endforeach
            </div>
        </div>
        <!-- Usage Rates -->
        <div class="mb-4">
            <h6 class="border-bottom pb-2 mb-3">Usage Rates ({{ count($planData['rates'] ?? []) }})</h6>
            @if (count($planData['rates'] ?? []) > 0)
                <div class="table-responsive">
                    <table class="table table-sm table-bordered">
                        <thead>
                            <tr>
                                <th>Usage Type</th>
                                <th>Per Unit Rate</th>
                                <th>Free Units</th>
                                {{-- <th>Over Limit Charge</th> --}}
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($planData['rates'] as $rate)
                                @php
                                    $type = $available_usage_types->get($rate['usage_type_id'] ?? null);
                                @endphp
                                <tr>
                                    <td> <strong>{{ $type->type_name ?? 'N/A' }}</strong>
                                        <div class="small text-muted">{{ $type->unit_name ?? '' }}
                                    </td>
                                    <td>{{ number_format($rate['rate_per_unit'] ?? 0, 2) }}
                                        {{ $planData['basic']['currency'] ?? '' }} Per
                                        {{ $type->unit_name ?? '' }}
                                    </td>
                                    <td>{{ number_format($rate['free_units'] ?? 0) }} {{ $type->unit_name ?? '' }}</td>
                                    {{-- <td>{{ $planData['basic']['currency'] }}
                                            {{ number_format($rate['overage_rate'], 2) }}
                                        </td> --}}
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-muted">No usage rates configured</p>
            @endif
        </div>

        <!-- Combo Plan Card -->
        <div class="mb-4">
            <h6 class="border-bottom pb-2 mb-3">Combo Plan
                {!! ($planData['basic']['is_combo'] ?? false)
                    ? '<i class="fas fa-check-circle text-success"></i>'
                    : '<i class="fas fa-times-circle text-danger"></i>' !!}</h6>
            @if ($planData['basic']['is_combo'] ?? false)
                @if ($showPlanSelection || $selectedPlanDetails)
                    <div class="col-12">
                        <div class="card review-card">
                            <div class="card-header bg-transparent">
                                <h5 class="mb-0"><i class="fas fa-credit-card me-2"></i>Subscription Plan
                                </h5>
                            </div>
                            <div class="card-body">
                                @if ($selectedPlanDetails)
                                    <div class="alert alert-primary">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <h6 class="mb-1">
                                                    {{ $selectedPlanDetails->plan_name }}
                                                </h6>
                                                <div class="text-muted small">
                                                    {{ ucfirst($selectedPlanDetails->plan_type) }}
                                                    plan •
                                                    @if ($selectedPlanDetails->discounted_price)
                                                        <span class="text-danger ms-2">
                                                            <s>${{ number_format($selectedPlanDetails->base_price, 2) }}</s>
                                                            ${{ number_format($selectedPlanDetails->discounted_price, 2) }}
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                            <button wire:click="togglePlanSelection"
                                                class="btn btn-sm btn-outline-primary">
                                                Change Plan
                                            </button>
                                        </div>

                                        @if ($selectedPlanDetails->description)
                                            <div class="mt-3">
                                                <p class="small mb-1"><strong>Includes:</strong>
                                                </p>
                                                <p class="small text-muted">
                                                    {{ $selectedPlanDetails->description }}
                                                </p>
                                            </div>
                                        @endif

                                        <div class="mt-3 row">
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-user-md me-2"></i>
                                                    Doctors:</p>
                                                <p class="small text-muted">
                                                    {{ $selectedPlanLimits->included_doctors ?? 'Unlimited' }}
                                                </p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-users me-2"></i>
                                                    Staff:
                                                </p>
                                                <p class="small text-muted">
                                                    {{ $selectedPlanLimits->included_staff ?? 'Unlimited' }}
                                                </p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-mobile-alt me-2"></i>
                                                    Devices:</p>
                                                <p class="small text-muted">
                                                    {{ $selectedPlanDetails->device_limit ?? 'Unlimited' }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="mt-3 row">
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-database me-2"></i>
                                                    Storage:</p>
                                                <p class="small text-muted">
                                                    {{ $selectedPlanLimits->storage_limit_gb ?? 'Unlimited' }}
                                                    GB
                                                </p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-video me-2"></i>
                                                    Teleconsultation:
                                                </p>
                                                <p class="small text-muted">
                                                    {{ $selectedPlanLimits->teleconsultation_minutes ?? 'Unlimited' }}
                                                    Minutes
                                                </p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-sms me-2"></i>
                                                    SMS:</p>
                                                <p class="small text-muted">
                                                    {{ $selectedPlanLimits->sms_limit ?? 'Unlimited' }}
                                                    Massages
                                                </p>
                                            </div>
                                        </div>

                                    </div>
                                @endif

                                @if ($showPlanSelection)
                                    <div class="mt-4">
                                        <h6 class="mb-3">Select a Plan:</h6>
                                        <div class="row">
                                            @foreach ($availablePlans as $plan)
                                                <div class="col-md-4 mb-3">
                                                    <div class="card plan-card h-100 cursor-pointer {{ $selected_plan_id == $plan->id ? 'border-primary' : '' }}"
                                                        wire:click="$set('selected_plan_id', {{ $plan->id }})">
                                                        <div class="card-body">
                                                            <h5 class="card-title">
                                                                {{ $plan->plan_name }}
                                                            </h5>
                                                            <h6 class="mb-3">
                                                                ${{ number_format($plan->base_price, 2) }}
                                                                <small
                                                                    class="text-muted">/{{ $plan->plan_type }}</small>
                                                            </h6>

                                                            <ul class="list-unstyled small">
                                                                <li class="mb-2">
                                                                    <i
                                                                        class="fas fa-check-circle text-success me-2"></i>
                                                                    {{ $plan->max_doctors ?? 'Unlimited' }}
                                                                    Doctors
                                                                </li>
                                                                <li class="mb-2">
                                                                    <i
                                                                        class="fas fa-check-circle text-success me-2"></i>
                                                                    {{ $plan->max_staff ?? 'Unlimited' }}
                                                                    Staff
                                                                </li>
                                                                <li class="mb-2">
                                                                    <i
                                                                        class="fas fa-check-circle text-success me-2"></i>
                                                                    {{ $plan->device_limit ?? 'Unlimited' }}
                                                                    Devices
                                                                </li>
                                                                @if ($plan->trial_period)
                                                                    <li class="mb-2">
                                                                        <i
                                                                            class="fas fa-check-circle text-success me-2"></i>
                                                                        {{ $plan->trial_period }}
                                                                        day trial
                                                                    </li>
                                                                @endif
                                                            </ul>

                                                            @if ($plan->discounted_price)
                                                                <div class="badge bg-danger mb-2">
                                                                    Save
                                                                    {{ number_format(100 - ($plan->discounted_price / $plan->base_price) * 100, 0) }}%
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>

                                        <div class="d-flex justify-content-end mt-3">
                                            <button wire:click="togglePlanSelection" class="btn btn-secondary">
                                                Cancel
                                            </button>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @else
                    <div class="text-center py-4">
                        <p class="text-muted mb-3">No subscription plan selected
                        </p>
                        <button wire:click="togglePlanSelection" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Add Subscription Plan
                        </button>
                    </div>
                @endif

                <!-- Add On Plan Card -->
                @if ($showAddOnSelection || $selectedAddOnDetails)
                    <div class="col-12">
                        <div class="card review-card">
                            <div class="card-header bg-transparent">
                                <div class="d-flex justify-content-between mt-3">
                                    <h5 class="mb-0"><i class="fas fa-credit-card me-2"></i>All
                                        Add On</h5>
                                    @if (!$showAddOnSelection)
                                        <button wire:click="toggleAddOnSelection"
                                            class="btn btn-sm btn-outline-primary">
                                            Change Add Ons
                                        </button>
                                    @endif
                                </div>
                            </div>
                            <div class="card-body">
                                @if ($selectedAddOnDetails)
                                    @foreach ($selectedAddOnDetails as $addOn)
                                        <div class="alert alert-primary">
                                            <div class="d-flex justify-content-between align-items-center">

                                                <div>
                                                    <h6 class="mb-1">
                                                        {{ $addOn->name }}
                                                    </h6>
                                                </div>
                                                <div class="text-muted small">
                                                    {{ ucfirst($addOn->resource_type) }}
                                                    Add On • Per {{ $addOn->unit }} Price
                                                    ${{ number_format($addOn->price_per_unit, 2) }}
                                                </div>
                                                @if ($addOn->price_per_unit)
                                                    <div class="text-muted small">
                                                        Total amount •
                                                        <span class="text-danger ms-2">
                                                            {{-- <s>${{ number_format($addOn->price_per_unit * $addOn->unit_counts, 2) }}</s> --}}
                                                            ${{ number_format($addOn->price_per_unit * $addOn->unit_counts, 2) }}
                                                        </span>
                                                    </div>
                                                @endif
                                            </div>

                                            @if ($addOn->description)
                                                <div class="mt-3">
                                                    <p class="small mb-1">
                                                        <strong>Includes:</strong>
                                                    </p>
                                                    <p class="small text-muted">
                                                        {{ $addOn->description }}
                                                    </p>
                                                </div>
                                            @endif

                                        </div>
                                    @endforeach
                                @endif

                                @if ($showAddOnSelection)
                                    <div class="mt-4">
                                        <h6 class="mb-3">Select an Add On:</h6>
                                        <div class="col-md-6">
                                            <label class="form-label">Clinic Add On
                                                (Optional)</label>
                                            <div class="dropdown">
                                                <!-- Dynamic dropdown button title -->
                                                <button class="form-select text-start dropdown-toggle" type="button"
                                                    id="addOnDropdown" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                    @if (count($selected_add_on_id) > 0)
                                                        {{ count($selected_add_on_id) }}
                                                        {{ count($selected_add_on_id) == 1 ? 'Add On' : 'Add Ons' }}
                                                        Selected
                                                    @else
                                                        -- Select Add Ons --
                                                    @endif
                                                </button>

                                                <!-- Checkbox options -->
                                                <ul class="dropdown-menu w-100" aria-labelledby="addOnDropdown">
                                                    @foreach ($availableAddOns as $addOn)
                                                        <li>
                                                            <div class="dropdown-item">
                                                                <input type="checkbox" wire:model="selected_add_on_id"
                                                                    value="{{ $addOn->id }}"
                                                                    id="addon-{{ $addOn->id }}"
                                                                    wire:change="updateSelectedCount">
                                                                <label for="addon-{{ $addOn->id }}"
                                                                    class="ms-2">
                                                                    {{ $addOn->name }}
                                                                    ({{ $addOn->price_per_unit }}/{{ $addOn->resource_type }})
                                                                </label>
                                                            </div>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>

                                            <!-- Selected items details -->
                                            @if (count($selected_add_on_id) > 0)
                                                <div class="mt-2 small text-muted">
                                                    <strong>Selected:</strong>
                                                    @foreach ($availableAddOns->whereIn('id', $selected_add_on_id) as $selected)
                                                        <span class="d-block">
                                                            {{ $selected->name }}
                                                            ({{ $selected->resource_type }})
                                                        </span>
                                                    @endforeach
                                                </div>
                                            @endif
                                        </div>

                                        <div class="d-flex justify-content-between mt-3">
                                            <button wire:click="toggleAddOnSelection" class="btn btn-success">
                                                Done
                                            </button>
                                            <button wire:click="toggleAddOnSelection" class="btn btn-secondary">
                                                Cancel
                                            </button>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @else
                    <div class="text-center py-4">
                        <p class="text-muted mb-3">No Add On's selected
                        </p>
                        <button wire:click="toggleAddOnSelection" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Add Add On
                        </button>
                    </div>
                @endif
            @endif
        </div>
    </div>
    <div class="card-footer">
        <div class="mt-4 d-flex justify-content-between">
            <button type="button" wire:click="previous" class="btn btn-secondary">Previous</button>
            <button type="button" wire:click="submit" class="btn btn-success">
                <i class="fas fa-check-circle me-2"></i>
                {{ $isEditing ? 'Update Plan' : 'Create Plan' }}
            </button>
        </div>
    </div>
</div>
