<div>
    <div class="card">
        <div class="card-header">
            <h5>Configure Usage Rates</h5>
            <p class="mb-0 text-muted">Define pricing for various usage types in this plan</p>
        </div>

        <div class="card-body">
            <!-- Add New Rate Form -->
            <div class="border rounded p-3 mb-4">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Usage Type*</label>
                        <select wire:model="current_usage_type" wire:change="updateUnitFromUsageType" class="form-select">
                            <option value="">Select Usage Type</option>
                            @foreach ($available_usage_types as $type)
                                <option value="{{ $type->id }}">
                                    {{ $type->type_name }} ({{ $type->unit_name }})
                                </option>
                            @endforeach
                        </select>
                        @error('current_usage_type')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Per {{$unit}} Rate*</label>
                        <div class="input-group">
                            <span class="input-group-text">
                                {{$currency}}
                            </span>
                            <input type="number" class="form-control" wire:model="current_rate_per_unit">
                        </div>
                        @error('current_rate_per_unit')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Free Units*</label>
                        <input type="number" wire:model="current_free_units" class="form-control" min="0">
                        @error('current_free_units')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    {{-- <div class="col-md-4">
                        <label class="form-label">Over Limit Charge*</label>
                        <div class="input-group">
                            <span class="input-group-text">
                                {{$currency}}
                            </span>
                            <input type="number" wire:model="current_overage_rate" class="form-control" min="0"
                                step="0.01">
                        </div>
                        @error('current_overage_rate')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div> --}}

                    <div class="col-md-2 d-flex align-items-end">
                        <button wire:click="addUsageRate" class="btn btn-primary w-100">
                            <i class="fas fa-plus me-1"></i> Add Rate
                        </button>
                    </div>
                </div>
            </div>

            <!-- Existing Rates Table -->
            @if (count($usage_rates) > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Usage Type</th>
                                <th>Per Unit Rate</th>
                                <th>Free Units</th>
                                {{-- <th>Over Limit Charge</th> --}}
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($usage_rates as $index => $rate)
                                @php
                                    $type = $available_usage_types->firstWhere('id', $rate['usage_type_id']);
                                @endphp
                                <tr>
                                    <td>
                                        <strong>{{ $type->type_name ?? 'N/A' }}</strong>
                                        <div class="small text-muted">{{ $type->unit_name ?? '' }}</div>
                                    </td>
                                    <td>{{ number_format($rate['rate_per_unit'], 2) }} {{ $currency }} Per {{$type->unit_name}}</td>
                                    <td>{{ number_format($rate['free_units']) }} {{$type->unit_name}}</td>
                                    {{-- <td>{{ $currency }} {{ number_format($rate['overage_rate'], 2) }}</td> --}}
                                    <td class="text-center">
                                        <button wire:click="removeUsageRate({{ $index }})"
                                            class="btn btn-sm btn-outline-danger" title="Remove">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i> No usage rates configured yet.
                </div>
            @endif
        </div>
    </div>

    <div class="mt-4 d-flex justify-content-between">
        <button type="button" wire:click="previous" class="btn btn-secondary">Previous</button>
        <button type="button" wire:click="next" class="btn btn-primary">Next: Review</button>
    </div>
</div>
