<div class="content">
    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="{{ route('admin.plans.addons.index') }}" class="text-dark">
                        <i
                            class="ti ti-chevron-left me-1"></i>{{ isset($usageTypes) ? 'Edit Usage type' : 'Add Usage type' }}
                    </a>
                </h6>
            </div>

            @if (session()->has('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5>{{ isset($usageType) && $usageType->exists ? 'Edit Usage Type' : 'Add New Usage Type' }}
                            </h5>
                            <a href="{{ route('admin.plans.usage-types.index') }}"
                                class="btn btn-sm btn-secondary">Back</a>
                        </div>

                        <div class="card-body">
                            @if (session()->has('message'))
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    {{ session('message') }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                </div>
                            @endif

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label for="type_name" class="form-label">Type Name</label>
                                    <input wire:model.defer="type_name" type="text" id="type_name"
                                        class="form-control" placeholder="e.g., Storage">
                                    @error('type_name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label for="unit_name" class="form-label">Unit Name</label>
                                    <input wire:model.defer="unit_name" type="text" id="unit_name"
                                        class="form-control" placeholder="e.g., GB">
                                    @error('unit_name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-12">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea wire:model.defer="description" id="description" class="form-control" rows="3"
                                        placeholder="Short description"></textarea>
                                    @error('description')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Status</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" wire:model="is_active"
                                                id="statusActive" value="1">
                                            <label class="form-check-label" for="statusActive">Active</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" wire:model="is_active"
                                                id="statusInactive" value="0">
                                            <label class="form-check-label" for="statusInactive">Inactive</label>
                                        </div>
                                    </div>
                                    @error('is_active')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-12">
                                    <button wire:click="save"
                                        class="btn btn-primary float-end">{{ isset($usageType) && $usageType->exists ? 'Update Usage Type' : 'Create Usage Type' }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
