<div class="content">
    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="{{ route('admin.subscription-plans.list') }}" class="text-dark">
                        <i
                            class="ti ti-chevron-left me-1"></i>{{ 'Subscription Plan View' }}
                    </a>
                </h6>
            </div>
            <!-- page header end -->
            <div class="card">
                <div class="card-header">
                    <h5>View Plan Details</h5>
                </div>

                <div class="card-body">
                    <!-- Basic Information -->
                    <div class="mb-5">
                        <h6 class="border-bottom pb-2 mb-3">Basic Information</h6>
                        <div class="row">
                            <div class="col-md-4">
                                <p><strong>Plan Code:</strong> {{ $planData['basic']['plan_code'] }}</p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Plan Name:</strong> {{ $planData['basic']['plan_name'] }}</p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Plan Type:</strong> {{ ucfirst($planData['basic']['plan_type']) }}</p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Duration:</strong> {{ $planData['basic']['duration'] }}
                                    {{ $planData['basic']['plan_type'] === 'monthly' ? 'Month(s)' : 'Year(s)' }}</p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Base Price:</strong> {{ $planData['basic']['currency'] }}
                                    {{ number_format($planData['basic']['base_price'], 2) }}</p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Status:</strong> {{ ucfirst($planData['basic']['plan_status']) }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Plan Limits -->
                    <div class="mb-5">
                        <h6 class="border-bottom pb-2 mb-3">Plan Limits</h6>
                        <div class="row">
                            <div class="col-md-4">
                                <p><strong>Max Doctors:</strong> {{ $planData['limits']['included_doctors'] }}</p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Additional Doctor Price:</strong> {{ $planData['basic']['currency'] }}
                                    {{ number_format($planData['limits']['additional_doctor_price'], 2) }}</p>
                            </div>
                            <div class="col-md-4">
                            </div>
                            <div class="col-md-4">
                                <p><strong>Max Staff:</strong> {{ $planData['limits']['included_staff'] }}</p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Storage Limit:</strong> {{ $planData['limits']['storage_limit_gb'] }} GB</p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Teleconsultation:</strong>
                                    {{ $planData['limits']['teleconsultation_minutes'] }}
                                    minutes</p>
                            </div>
                        </div>
                    </div>

                    <!-- Included Features -->
                    <div class="mb-5">
                        <h6 class="border-bottom pb-2 mb-3">Included Features ({{ count($planData['features']) }})</h6>
                        <div class="row">
                            @foreach ($available_features as $feature)
                                <div class="col-md-4 mb-2">
                                    <i class="fas fa-check-circle text-success me-2"></i>
                                    {{ $feature->feature_name }}
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- Usage Rates -->
                    <div class="mb-4">
                        <h6 class="border-bottom pb-2 mb-3">Usage Rates ({{ count($planData['rates']) }})</h6>
                        @if (count($planData['rates']) > 0)
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Usage Type</th>
                                            <th>Per Unit Rate</th>
                                            <th>Free Units</th>
                                            {{-- <th>Over Limit Charge</th> --}}
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($planData['rates'] as $rate)
                                            @php
                                                $type = $available_usage_types->get($rate['usage_type_id']);
                                            @endphp
                                            <tr>
                                                <td> <strong>{{ $type->type_name ?? 'N/A' }}</strong>
                                                    <div class="small text-muted">{{ $type->unit_name ?? '' }}
                                                </td>
                                                <td>{{ number_format($rate['rate_per_unit'], 2) }}
                                                    {{ $planData['basic']['currency'] }} Per
                                                    {{ $type->unit_name }}
                                                </td>
                                                <td>{{ number_format($rate['free_units']) }}
                                                    {{ $type->unit_name ?? '' }}
                                                </td>
                                                {{-- <td>{{ $planData['basic']['currency'] }}
                                        {{ number_format($rate['overage_rate'], 2) }}
                                    </td> --}}
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-muted">No usage rates configured</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
