<div class="content">
    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="{{ route('admin.subscription-plans.list') }}" class="text-dark">
                        <i class="ti ti-chevron-left me-1"></i>{{ isset($feature) ? 'Edit Feature' : 'Add Feature' }}
                    </a>
                </h6>
            </div>

            @if (session()->has('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5>{{ isset($feature) && $feature->exists ? 'Edit Feature' : 'Add New Feature' }}</h5>
                            <a href="{{ route('admin.plans.features.index') }}"
                                class="btn btn-sm btn-secondary">Back</a>
                        </div>

                        <div class="card-body">
                            @if (session()->has('message'))
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    {{ session('message') }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                </div>
                            @endif

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label for="feature_code" class="form-label">Feature Code</label>
                                    <input wire:model.defer="feature_code" type="text" id="feature_code"
                                        class="form-control" placeholder="e.g., STORAGE">
                                    @error('feature_code')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label for="feature_name" class="form-label">Feature Name</label>
                                    <input wire:model.defer="feature_name" type="text" id="feature_name"
                                        class="form-control" placeholder="e.g., Storage Space">
                                    @error('feature_name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-12">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea wire:model.defer="description" id="description" class="form-control" rows="3"
                                        placeholder="Feature description"></textarea>
                                    @error('description')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label class="form-label">Base Feature</label>
                                    <div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" wire:model="is_base_feature"
                                                id="is_base_feature" value="1"
                                                {{ $is_base_feature ? 'checked' : '' }}>
                                            <label class="form-check-label" for="is_base_feature">Is this a base
                                                feature?</label>
                                        </div>
                                    </div>
                                    @error('is_base_feature')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-4">
                                    <label for="feature_status" class="form-label">Status</label>
                                    <select wire:model.defer="feature_status" id="feature_status" class="form-select">
                                        <option value="active">Active</option>
                                        <option value="inactive">Inactive</option>
                                        <option value="beta">Beta</option>
                                    </select>
                                    @error('feature_status')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="category" class="form-label">Category</label>
                                    <input wire:model.defer="category" type="text" id="category"
                                        class="form-control" placeholder="e.g., Storage">
                                    @error('category')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-12">
                                    <button wire:click="save" class="btn btn-primary float-end">
                                        {{ isset($feature) && $feature->exists ? 'Update Feature' : 'Create Feature' }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
