<div class="content pb-0">
    <!-- Start Page Header -->
    <div class="mb-3">
        <h6 class="fw-semibold fs-14 mb-0">
            <a href="{{ back()->getTargetUrl() }}"><i class="ti ti-chevron-left me-1"></i>Doctors</a>
        </h6>
    </div>
    <!-- End Page Header -->

    <div class="card">
        <div class="card-body d-flex align-items-center justify-content-between flex-wrap row-gap-3">
            <div class="d-flex align-items-center flex-sm-nowrap flex-wrap row-gap-3">
                <img src="{{ asset('assets/img/icons/shape-01.svg') }}" alt="img" class="z-n1 position-absolute end-0 top-0 d-none d-lg-flex">
                <div class="me-3 doctor-profile-img">
                    @if ($doctor->profile_photo_url)
                        <img src="{{ $doctor->profile_photo_url }}" class="rounded" alt="Doctor Photo"
                            style="width: 120px; height: 120px; object-fit: cover;">
                    @else
                        {!! $doctor->getInitialsAvatar() !!}
                    @endif
                </div>
                <div class="flex-fill">
                    <div class="d-flex align-items-center mb-1">
                        <h6 class="mb-0 fw-semibold">{{ $doctor->name }}</h6>
                        <span class="badge border bg-white text-dark fw-medium ms-2">
                            <i class="ti ti-point-filled me-1 text-info"></i>
                            {{ $doctor->doctor->specialization ?? ($doctor->doctorProfile->specialization ?? 'N/A') }}
                        </span>
                    </div>
                    <span class="d-block mb-3 fs-13">{{ $doctor->doctor->qualifications ?? 'N/A' }}</span>
                    <div class="d-flex align-items-center">
                        @if ($primaryClinic)
                            <p class="mb-0 fs-13"><i class="ti ti-building-hospital me-1"></i>
                                Clinic : {{ $primaryClinic->name }}
                            </p>
                        @endif
                        <span
                            class="badge badge-soft-{{ $doctor->status === 'active' ? 'success' : 'danger' }} fw-medium ms-2">
                            <i
                                class="ti ti-point-filled me-1 text-{{ $doctor->status === 'active' ? 'success' : 'danger' }}"></i>
                            {{ ucfirst($doctor->status) }}
                        </span>
                    </div>
                </div>
            </div>
            <div>
                @if ($primaryClinic && $primaryClinic->pivot)
                    <p class="mb-2">Consultation Charge</p>
                    <h6 class="fs-18 fw-bold mb-3">
                        ₹{{ number_format($primaryClinic->pivot->in_person_fee ?? 0, 2) }}
                        <span class="fw-normal text-body fs-14"> /
                            {{ $primaryClinic->pivot->in_person_duration ?? 30 }} Min</span>
                    </h6>
                @endif
                <a href="#" class="btn btn-primary"><i class="ti ti-calendar-event me-1"></i>Book Appointment</a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <!-- Availability Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Availability</h5>
                    <ul class="nav nav-tabs nav-bordered nav-border-bottom mb-3">
                        @foreach (['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'] as $day)
                            <li class="nav-item flex-fill">
                                <a class="nav-link text-center fw-semibold {{ $loop->first ? 'active' : '' }}"
                                    href="javascript:void(0);" data-bs-toggle="tab"
                                    data-bs-target="#available-tab-{{ $loop->index + 1 }}">
                                    {{ $day }}
                                </a>
                            </li>
                        @endforeach
                    </ul>
                    <div class="tab-content" id="pills-tabContent">
                        @foreach (range(1, 5) as $day)
                            <div class="tab-pane fade {{ $loop->first ? 'active show' : '' }}"
                                id="available-tab-{{ $day }}" role="tabpanel">
                                <div class="d-flex align-items-center flex-wrap gap-2">
                                    <!-- You would replace this with actual availability data -->
                                    @foreach (['11:30 AM - 12:30 PM', '12:30 PM - 01:30 PM', '02:30 PM - 03:30 PM'] as $time)
                                        <a href="#"
                                            class="d-inline-flex align-items-center bg-light rounded flex-fill text-center justify-content-center p-1 text-dark">
                                            {{ $time }}
                                        </a>
                                    @endforeach
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Bio Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Short Bio</h5>
                    <p>{{ $doctor->doctor->bio ?? ($doctor->doctorProfile->bio ?? 'No biography available.') }}</p>
                    @if (
                        ($doctor->doctor->bio ?? $doctor->doctorProfile->bio) &&
                            strlen($doctor->doctor->bio ?? $doctor->doctorProfile->bio) > 200)
                        <div class="more-menu" style="display: none;">
                            <p>{{ substr($doctor->doctor->bio ?? $doctor->doctorProfile->bio, 200) }}</p>
                        </div>
                        <div class="view-all mt-2">
                            <a href="javascript:void(0);" class="viewall-button text-primary fw-medium">
                                <span>See More</span>
                                <i class="ti ti-chevron-down fs-10 ms-2"></i>
                            </a>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Education Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Education Information</h5>
                    <ul class="activity-feed rounded">
                        @forelse($educations as $education)
                            <li class="feed-item timeline-item">
                                <h6 class="fw-bold mb-2">{{ $education->institution }} - {{ $education->degree }}</h6>
                                @if ($education->field_of_study)
                                    <p class="mb-1">{{ $education->field_of_study }}</p>
                                @endif
                                <p>
                                    {{ $education->start_year }} -
                                    @if ($education->is_current)
                                        Present
                                    @else
                                        {{ $education->end_year }}
                                    @endif
                                </p>
                                @if ($education->description)
                                    <p class="mt-2">{{ $education->description }}</p>
                                @endif
                            </li>
                        @empty
                            <li class="feed-item timeline-item">
                                <p>No education information available.</p>
                            </li>
                        @endforelse
                    </ul>
                </div>
            </div>

            <!-- Experience Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Work Experience</h5>
                    <ul class="activity-feed rounded">
                        @forelse($experiences as $experience)
                            <li class="feed-item timeline-item">
                                <h6 class="fw-bold mb-2">{{ $experience->position }} at
                                    {{ $experience->organization }}</h6>
                                <p>
                                    {{ $experience->start_date->format('M Y') }} -
                                    @if ($experience->is_current)
                                        Present
                                    @else
                                        {{ $experience->end_date->format('M Y') }}
                                    @endif
                                </p>
                                @if ($experience->description)
                                    <p class="mt-2">{{ $experience->description }}</p>
                                @endif
                            </li>
                        @empty
                            <li class="feed-item timeline-item">
                                <p>No work experience information available.</p>
                            </li>
                        @endforelse
                    </ul>
                </div>
            </div>

            <!-- Clinics Section -->
            @if ($clinics->isNotEmpty())
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-bold mb-3">Associated Clinics</h5>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Clinic Name</th>
                                        <th>Status</th>
                                        <th>Services</th>
                                        <th>Fees</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($clinics as $clinic)
                                        <tr>
                                            <td>
                                                {{ $clinic->name }}
                                                @if ($clinic->pivot->is_primary)
                                                    <span class="badge bg-primary ms-2">Primary</span>
                                                @endif
                                            </td>
                                            <td>
                                                <span
                                                    class="badge badge-soft-{{ $clinic->pivot->status === 'active' ? 'success' : 'danger' }}">
                                                    {{ ucfirst($clinic->pivot->status) }}
                                                </span>
                                            </td>
                                            <td>
                                                @if ($clinic->pivot->offers_in_person)
                                                    In-Person
                                                @endif
                                                @if ($clinic->pivot->offers_video)
                                                    Video
                                                @endif
                                                @if ($clinic->pivot->offers_home_visit)
                                                    Home Visit
                                                @endif
                                            </td>
                                            <td>
                                                @if ($clinic->pivot->offers_in_person)
                                                    ₹{{ number_format($clinic->pivot->in_person_fee, 2) }}
                                                    ({{ $clinic->pivot->in_person_duration }} min)
                                                    <br>
                                                @endif
                                                @if ($clinic->pivot->offers_video)
                                                    ₹{{ number_format($clinic->pivot->video_fee, 2) }}
                                                    ({{ $clinic->pivot->video_duration }} min)<br>
                                                @endif
                                                @if ($clinic->pivot->offers_home_visit)
                                                    ₹{{ number_format($clinic->pivot->home_visit_fee, 2) }}
                                                    ({{ $clinic->pivot->home_visit_duration }} min)
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Certifications Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Certifications & Licenses</h5>
                    <div class="mb-3">
                        <div class="d-flex align-items-center mb-2">
                            <span class="me-2"><i class="ti ti-award"></i></span>
                            <h6 class="mb-0 fw-bold">License:
                                {{ $doctor->doctor->license_number ?? ($doctor->doctorProfile->license_number ?? 'N/A') }}
                            </h6>
                        </div>
                        @if ($doctor->doctorProfile && $doctor->doctorProfile->license_state)
                            <p>State: {{ $doctor->doctorProfile->license_state }}</p>
                        @endif
                        @if ($doctor->doctorProfile && $doctor->doctorProfile->license_valid_until)
                            <p>Valid Until: {{ $doctor->doctorProfile->license_valid_until->format('M d, Y') }}</p>
                        @endif
                    </div>

                    @if ($doctor->doctorProfile && $doctor->doctorProfile->certificates)
                        @foreach ($doctor->doctorProfile->certificates as $certificate)
                            <div class="mb-3">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="me-2"><i class="ti ti-certificate"></i></span>
                                    <h6 class="mb-0 fw-bold">{{ $certificate['name'] ?? 'Certificate' }}</h6>
                                </div>
                                @if (isset($certificate['date']))
                                    <p>Date: {{ $certificate['date'] }}</p>
                                @endif
                                @if (isset($certificate['issuer']))
                                    <p>Issuer: {{ $certificate['issuer'] }}</p>
                                @endif
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>

        <!-- Sidebar Section -->
        <div class="col-xl-4 theiaStickySidebar">
            <div class="card">
                <div class="card-body">
                    <h6 class="fw-bold mb-3">About</h6>
                    <div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-file"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Medical License Number</h6>
                                <p>{{ $doctor->doctor->license_number ?? ($doctor->doctorProfile->license_number ?? 'N/A') }}
                                </p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-phone"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Phone Number</h6>
                                <p>{{ $doctor->phone ?? 'N/A' }}</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-mail"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Email Address</h6>
                                <p>{{ $doctor->email }}</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-user-check"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Years of Experience</h6>
                                <p>{{ $doctor->doctor->experience_years ?? ($doctor->doctorProfile->years_of_experience ?? '0') }}
                                    Years</p>
                            </div>
                        </div>
                        @if ($doctor->doctorProfile && $doctor->doctorProfile->languages_spoken)
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-language"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Languages Spoken</h6>
                                    <p>{{ implode(', ', $doctor->doctorProfile->languages_spoken) }}</p>
                                </div>
                            </div>
                        @endif
                        @if ($doctor->doctorProfile && $doctor->doctorProfile->sub_specializations)
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-stethoscope"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Sub-specializations</h6>
                                    <p>{{ implode(', ', $doctor->doctorProfile->sub_specializations) }}</p>
                                </div>
                            </div>
                        @endif
                        @if ($doctor->doctorProfile)
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-user-plus"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Accepts New Patients</h6>
                                    <p>{{ $doctor->doctorProfile->accepts_new_patients ? 'Yes' : 'No' }}</p>
                                </div>
                            </div>
                        @endif
                        @if ($doctor->doctorProfile && $doctor->doctorProfile->verification_status)
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-shield-check"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Verification Status</h6>
                                    <p class="text-capitalize">{{ $doctor->doctorProfile->verification_status }}</p>
                                    @if ($doctor->doctorProfile->verified_at)
                                        <small class="text-muted">Verified on:
                                            {{ $doctor->doctorProfile->verified_at->format('M d, Y') }}</small>
                                    @endif
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Ratings Section -->
            @if ($doctor->doctorProfile && ($doctor->doctorProfile->rating || $doctor->doctorProfile->reviews_count))
                <div class="card">
                    <div class="card-body">
                        <h6 class="fw-bold mb-3">Ratings & Reviews</h6>
                        <div class="text-center">
                            <div class="d-flex align-items-center justify-content-center mb-2">
                                <h2 class="me-2 mb-0">{{ number_format($doctor->doctorProfile->rating, 1) }}</h2>
                                <div class="star-rating">
                                    @for ($i = 1; $i <= 5; $i++)
                                        @if ($i <= floor($doctor->doctorProfile->rating))
                                            <i class="ti ti-star-filled text-warning"></i>
                                        @elseif($i - 0.5 <= $doctor->doctorProfile->rating)
                                            <i class="ti ti-star-half-filled text-warning"></i>
                                        @else
                                            <i class="ti ti-star text-warning"></i>
                                        @endif
                                    @endfor
                                </div>
                            </div>
                            <p class="text-muted">{{ $doctor->doctorProfile->reviews_count }} reviews</p>
                            <a href="#" class="btn btn-outline-primary btn-sm">View All Reviews</a>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

@push('scripts')
    <script>
        // For the "See More" functionality
        $(document).ready(function() {
            $('.viewall-button').click(function() {
                $(this).closest('.card-body').find('.more-menu').toggle();
                var span = $(this).find('span');
                var icon = $(this).find('i');

                if (span.text() === 'See More') {
                    span.text('See Less');
                    icon.removeClass('ti ti-chevron-down').addClass('ti ti-chevron-up');
                } else {
                    span.text('See More');
                    icon.removeClass('ti ti-chevron-up').addClass('ti ti-chevron-down');
                }
            });
        });
    </script>
@endpush
