<div class="content">
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">
                Active Devices Tracking
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    Total Devices: {{ count($this->filteredDevices) }}
                </span>
            </h4>
        </div>

        <div class="text-end d-flex">
            <button wire:click="polling"
                class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center me-2">
                <i class="ti ti-refresh me-1"></i> Refresh
            </button>
            @if (Auth::user()->is_superadmin)
                <div class="dropdown me-2">
                    <a href="javascript:void(0);"
                        class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                        data-bs-toggle="dropdown" data-bs-auto-close="outside">
                        <i class="ti ti-download me-1"></i> Export
                    </a>
                    <ul class="dropdown-menu p-2 bg-white">
                        <li>
                            <a class="dropdown-item" href="javascript:void(0);">Download as PDF</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="javascript:void(0);">Download as Excel</a>
                        </li>
                    </ul>
                </div>
            @endif
        </div>
    </div>
    <!-- End Page Header -->

    {{-- Success Message --}}
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3">
        <div class="search-set mb-3">
            <div class="d-flex align-items-center flex-wrap gap-2">
                @if (Auth::user()->is_superadmin)
                    <div class="table-search d-flex align-items-center mb-0 me-2">
                        <select wire:model.live="selectedUserId" class="form-select form-select-sm">
                            <option value="">All Users</option>
                            @foreach ($users as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>
                    </div>
                @endif
                <div class="table-search d-flex align-items-center mb-0">
                    <div class="search-input">
                        <a href="javascript:void(0);" class="btn-searchset"></a>
                        <input type="search" wire:model.live="search" class="form-control form-control-sm"
                            placeholder="Search devices...">
                    </div>
                </div>
            </div>
        </div>
        <div class="d-flex table-dropdown mb-3 pb-1 right-content align-items-center flex-wrap row-gap-3">
            <div class="dropdown me-2">
                <a href="javascript:void(0);"
                    class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                    data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                </a>
                <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                    <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                        <h4 class="mb-0">Filter</h4>
                        <div class="d-flex align-items-center">
                            <a href="javascript:void(0);" wire:click="resetFilters"
                                class="link-danger text-decoration-underline">Clear All</a>
                        </div>
                    </div>
                    <div class="filter-body pb-0">
                        <div class="mb-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <label class="form-label">Platform</label>
                                <a href="javascript:void(0);" wire:click="$set('platformFilter', 'all')"
                                    class="link-primary mb-1">Reset</a>
                            </div>
                            <select wire:model.live="platformFilter" class="form-select">
                                <option value="all">All Platforms</option>
                                <option value="web">Web</option>
                                <option value="mobile">Mobile</option>
                                <option value="windows">Windows</option>
                                <option value="mac">Mac</option>
                                <option value="linux">Linux</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <label class="form-label">Status</label>
                                <a href="javascript:void(0);" wire:click="$set('statusFilter', 'all')"
                                    class="link-primary mb-1">Reset</a>
                            </div>
                            <select wire:model.live="statusFilter" class="form-select">
                                <option value="all">All Status</option>
                                <option value="current">Current Device</option>
                                <option value="other">Other Devices</option>
                            </select>
                        </div>
                    </div>
                    <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                        <a href="javascript:void(0);" class="btn btn-light btn-md me-2" id="close-filter">Close</a>
                    </div>
                </div>
            </div>
            <div class="dropdown me-2">
                <a href="javascript:void(0);"
                    class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                    data-bs-toggle="dropdown">
                    <span class="me-1"> Sort By : </span>
                    @if ($sortField === 'last_active_at')
                        Last Active
                    @elseif($sortField === 'login_at')
                        Login Time
                    @elseif($sortField === 'device_name')
                        Device Name
                    @endif
                </a>
                <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                    <li>
                        <a href="javascript:void(0);" wire:click="sortBy('last_active_at')"
                            class="dropdown-item rounded-1">Last Active</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" wire:click="sortBy('login_at')"
                            class="dropdown-item rounded-1">Login
                            Time</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" wire:click="sortBy('device_name')"
                            class="dropdown-item rounded-1">Device Name</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table datatable table-nowrap">
            <thead class="">
                <tr>
                    <th>Device</th>
                    <th>User</th>
                    <th>Platform</th>
                    <th>IP Address</th>
                    <th>Login Time</th>
                    <th>Last Active</th>
                    <th>Status</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($this->filteredDevices as $device)
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="me-2">
                                    @if ($device['platform'] === 'mobile')
                                        <i class="ti ti-device-mobile fs-4 text-primary"></i>
                                    @elseif($device['platform'] === 'windows' || $device['platform'] === 'mac' || $device['platform'] === 'linux')
                                        <i class="ti ti-device-laptop fs-4 text-info"></i>
                                    @else
                                        <i class="ti ti-world fs-4 text-success"></i>
                                    @endif
                                </div>
                                <div>
                                    {{ $device['device_name'] ?? 'Unknown Device' }}
                                    @if ($device['is_current'])
                                        <span class="badge bg-primary ms-1">Current</span>
                                    @endif
                                </div>
                            </div>
                        </td>
                        <td>
                            @if (Auth::user()->is_superadmin)
                                {{ $this->getUserName($device['user_id']) }}
                            @else
                                {{ Auth::user()->name }}
                            @endif
                        </td>
                        <td>{{ ucfirst($device['platform'] ?? 'Web') }}</td>
                        <td>{{ $device['ip_address'] }}</td>
                        <td>{{ \Carbon\Carbon::parse($device['login_at'])->format('M d, Y H:i') }}</td>
                        <td>{{ \Carbon\Carbon::parse($device['last_active_at'])->diffForHumans() }}</td>
                        <td>
                            @if ($device['is_current'])
                                <span class="badge badge-soft-success border border-success">Active</span>
                            @else
                                <span class="badge badge-soft-warning border border-warning">Idle</span>
                            @endif
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="action-item">
                                    <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                        <i class="ti ti-dots-vertical"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end bg-white">
                                        <li>
                                            <a href="javascript:void(0);"
                                                wire:click="logoutDevice('{{ $device['device_id'] }}')"
                                                onclick="return confirm('Are you sure you want to log out this device?')"
                                                class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-logout me-2"></i> Logout Device
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center">No active devices found</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <x-table.pagination :paginator="$this->filteredDevices" :position="'both'" />

    <div wire:poll.60s="polling"></div>
</div>

<!-- Auto polling every 60 seconds -->
