<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>@yield('title', 'PRED Care')</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f6f8;
            margin: 0;
            padding: 0;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        .email-container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .email-header {
            background-color: #0d47a1;
            color: #ffffff;
            padding: 20px 30px;
            text-align: center;
        }

        .email-body {
            padding: 30px 40px;
            color: #333333;
            font-size: 16px;
            line-height: 1.6;
        }

        /* Clear and consistent heading spacing */
        .email-body h2 {
            margin: 0 0 18px 0;
            font-size: 24px;
            font-weight: bold;
            line-height: 1.3;
            color: #0d47a1;
        }

        .email-body h3 {
            margin: 30px 0 12px 0;
            font-size: 20px;
            font-weight: 600;
            line-height: 1.3;
            color: #0d47a1;
        }

        .email-body p {
            margin: 16px 0;
        }

        .email-body ul {
            margin: 16px 0;
            padding-left: 20px;
        }

        .email-body ul li {
            margin-bottom: 8px;
        }

        .email-footer {
            padding: 20px 30px;
            font-size: 13px;
            text-align: center;
            color: #888888;
            background-color: #f4f6f8;
        }

        .action-button {
            display: inline-block;
            margin: 24px 0;
            padding: 12px 28px;
            background-color: #0d47a1;
            color: #ffffff !important;
            text-decoration: none;
            border-radius: 4px;
            font-weight: 600;
            font-size: 16px;
        }

        a {
            color: #0d47a1;
            text-decoration: none;
        }

        a:hover {
            text-decoration: underline;
        }

        @media (max-width: 600px) {
            .email-body {
                padding: 20px 25px;
            }

            .email-header {
                padding: 20px 25px;
            }

            .email-footer {
                padding: 15px 20px;
            }
        }
    </style>
</head>

<body>
    <div class="email-container">
        <div class="email-header">
            <h1>PRED CARE</h1>
        </div>

        <div class="email-body">
            @yield('content')
        </div>

        <div class="email-footer">
            📧 <a href="mailto:info@predcare.in">info@predcare.in</a> |
            🌐 <a href="{{ config('app.url') }}">www.predcare.in</a><br />
            &copy; {{ now()->year }} PRED Care. All rights reserved.
        </div>
    </div>
</body>

</html>
