@extends('layouts.app')

@section('title', 'Edit Availability')

@section('content')
<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>

    <div class="content">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <!-- Page Header -->
                <div class="mb-4">
                    <h6 class="fw-bold mb-0 d-flex align-items-center">
                        <a href="{{ route('availability.list') }}" class="text-dark">
                            <i class="ti ti-chevron-left me-1"></i>Doctor Availability
                        </a>
                    </h6>
                </div>
                
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif


                <form action="{{ route('availability.update', $availability->id) }}" method="POST">
                    @csrf
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Edit Availability</h4>
                        </div>

                        <div class="card-body">
                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <label class="form-label">Select Doctor <span class="text-danger">*</span></label>
                                    <select class="form-select" name="doctor_id" required>
                                        <option value="">Select Any one</option>
                                        @foreach($doctors as $entry)
                                            <option value="{{ $entry->doctor->id }}" {{ $availability->doctor_id == $entry->doctor->id ? 'selected' : '' }}>
                                                {{ $entry->doctor->name }}
                                            </option>
                                        @endforeach
                                    </select>

                                    <!-- Clinic ID -->
                                    <input type="hidden" name="clinic_id" value="{{ $availability->clinic_id }}">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Slot Duration <span class="text-danger">*</span></label>
                                    <select class="form-select" name="slot_duration" required>
                                        <option value="">Select</option>
                                        <option value="15" {{ $availability->slot_duration == 15 ? 'selected' : '' }}>15 minutes</option>
                                        <option value="30" {{ $availability->slot_duration == 30 ? 'selected' : '' }}>30 minutes</option>
                                        <option value="60" {{ $availability->slot_duration == 60 ? 'selected' : '' }}>60 minutes</option>
                                    </select>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label">From Time</label>
                                        <input type="time" name="from_time" class="form-control" value="{{ old('from_time', \Carbon\Carbon::parse($availability->from_time)->format('H:i')) }}" required>

                                          <!-- <input type="time" class="form-control" name="from_time" required value="{{ old('from_time', $availability->from_time) }}"> -->
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label">To Time</label>
                                        <input type="time" name="to_time" class="form-control" value="{{ old('to_time', \Carbon\Carbon::parse($availability->to_time)->format('H:i')) }}" required>
                                        <!-- <input type="time" class="form-control" name="to_time" required value="{{ old('to_time', $availability->to_time) }}"> -->
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="row">
                                        <label class="form-label">Select Days</label>
                                        @php
                                            $selectedDays = json_decode($availability->day, true);
                                        @endphp
                                        @foreach(['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'] as $day)
                                            <div class="col-lg-3 mt-2">
                                                <ul class="list-group">
                                                    <li class="list-group-item">
                                                        <div class="form-check">
                                                            <input class="form-check-input me-1" type="checkbox" name="days[]" value="{{ $day }}"
                                                                id="day_{{ $day }}"
                                                                {{ in_array($day, $selectedDays ?? []) ? 'checked' : '' }}>
                                                            <label class="form-check-label" for="day_{{ $day }}">{{ $day }}</label>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label">Doctor Fee</label>
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">In-Person Fee</label>
                                                    <input type="number" class="form-control" name="in_person_fee" placeholder="Enter the fee" min="0" value="{{ $availability->in_person_fee }}" required>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Video Fee</label>
                                                    <input type="number" class="form-control" name="video_fee" placeholder="Enter the fee" min="0" value="{{ $availability->video_fee }}" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>

                        <div class="card-footer d-flex justify-content-between">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i> Update Availability
                            </button>
                            <a href="{{ route('availability.list') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i> Cancel
                            </a>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>

@endsection