@extends('layouts.app')

@section('title', 'Appointment List')

@section('content')

<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>

    <!-- Start Content -->
    <div class="content">

        <!-- Start Page Header -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 pb-3 mb-3 border-1 border-bottom">
            <div class="flex-grow-1">
                <h4 class="fw-semibold mb-0"> 
                    Appointment List
                    <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                        Total Appointment: {{ $appointments->count() }}
                    </span>
                </h4>
            </div>
            <div class="text-end d-flex">
                <!-- dropdown-->
                <!-- <div class="dropdown me-1">
                    <a href="javascript:void(0);" class="btn btn-md fs-14 fw-normal border bg-white rounded text-dark d-inline-flex align-items-center"  data-bs-toggle="dropdown">
                        Export<i class="ti ti-chevron-down ms-2"></i>
                    </a>
                    <ul class="dropdown-menu p-2">
                        <li>
                            <a class="dropdown-item" href="#">Download as PDF</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">Download as Excel</a>
                        </li>
                    </ul>
                </div> -->
                <!-- <div class="bg-white border shadow-sm rounded px-1 pb-0 text-center d-flex align-items-center justify-content-center">
                    <a href="{{url('appointments')}}" class="bg-light rounded p-1 d-flex align-items-center justify-content-center"> <i class="ti ti-list fs-14 text-dark"></i></a>
                    <a href="{{url('appointment-calendar')}}" class="bg-white rounded p-1 d-flex align-items-center justify-content-center"> <i class="ti ti-calendar-event fs-14 text-body"></i> </a>
                </div> -->

                <a href="{{ route('doctor.appointments.create') }}" class="btn btn-primary ms-2 fs-13 btn-md"><i class="ti ti-plus me-1"></i> New Appointment </a>
            </div>
        </div>
        <!-- End Page Header -->

        <!--  Start Filter -->
        <div class=" d-flex align-items-center justify-content-between flex-wrap">
            <div class="d-flex align-items-center gap-2">
                <div class="search-set mb-3">
                    <div class="d-flex align-items-center flex-wrap gap-2">
                        <div class="table-search d-flex align-items-center mb-0">
                            <div class="search-input">
                                <a href="javascript:void(0);" class="btn-searchset"></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="d-flex table-dropdown mb-3 right-content align-items-center flex-wrap row-gap-3">
                <!-- <div class="dropdown me-2">
                    <a href="javascript:void(0);" class="bg-white border rounded btn btn-md text-dark fs-14 py-1 align-items-center d-flex fw-normal" data-bs-toggle="dropdown" data-bs-auto-close="outside">
                        <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                    </a>
                    <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown p-0" id="filter-dropdown">
                        <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                            <h4 class="mb-0 fw-bold">Filter</h4>
                            <div class="d-flex align-items-center">
                                <a href="javascript:void(0);" class="link-danger text-decoration-underline">Clear All</a>
                            </div>
                        </div>
                        <form action="#">
                            <div class="filter-body pb-0">
                                <div class="mb-3">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <label class="form-label">Patient</label>
                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                    </div>
                                    <div class="dropdown">
                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                        </a>
                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                            <div class="mb-3">
                                                <div class="input-icon-start input-icon position-relative">
                                                    <span class="input-icon-addon fs-12">
                                                        <i class="ti ti-search"></i>
                                                    </span>
                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                </div>
                                            </div>
                                            <ul class="mb-3">
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="{{URL::asset('build/img/users/user-33.jpg')}}" class="flex-shrink-0 rounded-circle" alt="img"></span>Alberto Ripley
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="{{URL::asset('build/img/users/user-12.jpg')}}" class="flex-shrink-0 rounded-circle" alt="img"></span>Bernard Griffith
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="{{URL::asset('build/img/users/user-02.jpg')}}" class="flex-shrink-0 rounded-circle" alt="img"></span>Carol Lam
                                                    </label>
                                                </li>
                                                <li>
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="{{URL::asset('build/img/users/user-08.jpg')}}" class="flex-shrink-0 rounded-circle" alt="img"></span>Ezra Belcher
                                                    </label>
                                                </li>
                                            </ul>
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                </div>
                                                <div class="col-6">
                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <label class="form-label">Doctor</label>
                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                    </div>
                                    <div class="dropdown">
                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                        </a>
                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                            <div class="mb-3">
                                                <div class="input-icon-start input-icon position-relative">
                                                    <span class="input-icon-addon fs-12">
                                                        <i class="ti ti-search"></i>
                                                    </span>
                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                </div>
                                            </div>
                                            <ul class="mb-3">
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="{{URL::asset('build/img/doctors/doctor-01.jpg')}}" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Mick Thompson
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="{{URL::asset('build/img/doctors/doctor-02.jpg')}}" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Sarah Johnson
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="{{URL::asset('build/img/doctors/doctor-03.jpg')}}" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Emily Carter
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="{{URL::asset('build/img/doctors/doctor-04.jpg')}}" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. David Lee
                                                    </label>
                                                </li>
                                                <li class="mb-0">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="{{URL::asset('build/img/doctors/doctor-05.jpg')}}" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Anna Kim
                                                    </label>
                                                </li>
                                            </ul>
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                </div>
                                                <div class="col-6">
                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <label class="form-label">Designation</label>
                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                    </div>
                                    <div class="dropdown">
                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                        </a>
                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                            <div class="mb-3">
                                                <div class="input-icon-start input-icon position-relative">
                                                    <span class="input-icon-addon fs-12">
                                                        <i class="ti ti-search"></i>
                                                    </span>
                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                </div>
                                            </div>
                                            <ul class="mb-3">
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Cardiologist
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Orthopedic Surgeon
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Pediatrician
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Gynecologist
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Psychiatrist
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Neurosurgeon
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Oncologist
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Pulmonologist
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Urologist
                                                    </label>
                                                </li>
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Dermatologist
                                                    </label>
                                                </li>
                                            </ul>
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                </div>
                                                <div class="col-6">
                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <label class="form-label">Mode</label>
                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                    </div>
                                    <div class="dropdown">
                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                        </a>
                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                            <div class="mb-3">
                                                <div class="input-icon-start input-icon position-relative">
                                                    <span class="input-icon-addon fs-12">
                                                        <i class="ti ti-search"></i>
                                                    </span>
                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                </div>
                                            </div>
                                            <ul class="mb-3">
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        In Person
                                                    </label>
                                                </li>
                                                <li class="mb-0">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Online
                                                    </label>
                                                </li>
                                            </ul>
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                </div>
                                                <div class="col-6">
                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label mb-1 text-dark fs-14 fw-medium">Date<span class="text-danger">*</span></label>
                                    <div class="input-icon-end position-relative">  
                                        <input type="text" class="form-control bookingrange" placeholder="dd/mm/yyyy">
                                        <span class="input-icon-addon">
                                            <i class="ti ti-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <label class="form-label">Status</label>
                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                    </div>
                                    <div class="dropdown">
                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                        </a>
                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                            <div class="mb-3">
                                                <div class="input-icon-start input-icon position-relative">
                                                    <span class="input-icon-addon fs-12">
                                                        <i class="ti ti-search"></i>
                                                    </span>
                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                </div>
                                            </div>
                                            <ul class="mb-3">
                                                <li class="mb-1">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Checked Out
                                                    </label>
                                                </li>
                                                <li class="mb-0">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Checked In
                                                    </label>
                                                </li>
                                                <li class="mb-0">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Cancelled
                                                    </label>
                                                </li>
                                                <li class="mb-0">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Schedule
                                                    </label>
                                                </li>
                                                <li class="mb-0">
                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                        Confirmed
                                                    </label>
                                                </li>
                                            </ul>
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                </div>
                                                <div class="col-6">
                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                                <a href="javascript:void(0);" class="btn btn-light btn-md me-2 fw-medium" id="close-filter">Close</a>
                                <button type="submit" class="btn btn-primary btn-md fw-medium">Filter</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="dropdown">
                    <a href="javascript:void(0);" class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14" data-bs-toggle="dropdown">
                        <span  class="me-1"> Sort By : </span>  Recent
                    </a>
                    <ul class="dropdown-menu  dropdown-menu-end p-2">
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1">Recent</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1">Oldest</a>
                        </li>
                    </ul>
                </div> -->
            </div>
        </div>
        <!--  End Filter -->

        <!--  Start Table -->
        <div class="table-responsive">
            <table class="table datatable table-nowrap">
                <thead class="">
                    <tr>
                        <!-- <th>ID</th> -->
                        <th>Appointment ID</th>
                        <th>Patient</th>
                        <th>Doctor</th>
                        <th>Specialization</th>
                        <th>Appointment Date</th>
                        <th>Appointment Time (Slot)</th>
                        <th>Consultation Fees</th>
                        <th>Appointment Type</th>
                        <th>Reason</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($appointments as $item)
                        <tr>
                            <!-- <td>{{ $item->id }}</td> -->
                            <td>{{ $item->appointment_id }}</td>
                            <td>{{ $item->patient->name ?? 'N/A' }}</td>
                            <td>{{ $item->doctor->name ?? 'N/A' }}</td>
                            <td>{{ $item->specialization }}</td>
                            <td>{{ \Carbon\Carbon::parse($item->appointment_date)->isoFormat('D, MMMM YYYY') }}</td>
                            <td>
                                <ul class="list-unstyled mb-0">
                                    @foreach (json_decode($item->appointment_slot_time) as $slot)
                                        <li class="d-inline-block me-2 mb-2 px-3 border rounded bg-light">
                                            <i class="ti ti-clock me-1 text-primary"></i> {{ $slot }}
                                        </li><br>
                                    @endforeach
                                </ul>
                            </td>
                            <td>
                                <strong>
                                    @if ($item->fee_type === 'in_person_fee')
                                        In-Person
                                    @elseif ($item->fee_type === 'video_fee')
                                        Video
                                    @else
                                        {{ ucfirst(str_replace('_', ' ', $item->fee_type)) }}
                                    @endif
                                </strong>
                                - ${{ $item->appointment_fee }}
                            </td>
                            <td>
                                @if ($item->appointment_type === 'first_visit')
                                    First Visit
                                @elseif ($item->appointment_type === 'follow_up')
                                    Follow Up
                                @else
                                    {{ ucfirst($item->appointment_type) }}
                                @endif
                            </td>
                            <td>{{ $item->reason }}</td>
                            <td>
                                {{-- Appointment Status --}}
                                @if($item->appointment_status == 'completed')
                                    <span class="badge bg-success fw-medium">Completed</span>
                                @elseif($item->appointment_status == 'cancelled')
                                    <span class="badge bg-danger fw-medium">Cancelled</span>
                                @else
                                    @if ($item->fee_type === 'in_person_fee')
                                                
                                    @elseif ($item->fee_type === 'video_fee')
                                        <div class="">
                                            <a href="{{ route('doctor.call', [
                                                    'appointment_id' => $item->appointment_id,
                                                    'doctor_id'      => auth('doctor')->id(),
                                                    'patient_id'     => $item->patient_id, // optional but nice
                                                ]) }}"
                                                class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2"
                                                data-bs-toggle="tooltip" title="Start Video Call"> <i class="ti ti-video"></i>
                                            </a>
                                            
                                            <!-- <a href="{{ route('doctor.call') }}" class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2" data-bs-toggle="tooltip" title="Start Video Call">
                                                <i class="ti ti-video"></i>
                                            </a> -->
                                            <!-- <a href="{{ route('doctor.call') }}" class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14" data-bs-toggle="tooltip" title="Start Audio Call">
                                                <i class="ti ti-phone"></i>
                                            </a> -->
                                            <!-- <a href="{{ route('doctor.call') }}" class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14" data-bs-toggle="tooltip" title="Start Chat">
                                                <i class="ti ti-message-circle"></i>
                                            </a> -->
                                        </div>
                                    @endif
                                    <span class="badge bg-secondary fw-medium">{{ ucfirst($item->appointment_status) }}</span>
                                @endif

                                {{-- Doctor --}}
                                <!-- <a href="{{ route('doctor.invoice.show', $item->appointment_id) }}" class="btn btn-primary">
                                    View prescription
                                </a>
                                <a href="{{ route('doctor.invoice.download', $item->appointment_id) }}" class="btn btn-success">
                                    Download PDF
                                </a> --><br/><br/>
                                <a href="{{ route('doctor.invoice.show', $item->appointment_id) }}" class="btn btn-primary">
                                    View Prescription
                                </a>
                            </td>
                            <td class="action-item">
                                <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                    <i class="ti ti-dots-vertical"></i>
                                </a>
                                <ul class="dropdown-menu p-2">
                                    <!-- <li>
                                        <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center">Edit</a>
                                    </li> -->
                                    <li>
                                        @if($item->appointment_status == 'online' || $item->appointment_status == 'offline')
                                            <a href="{{ route('doctor.appointments.update-status', ['id' => $item->id, 'status' => 'completed']) }}" class="dropdown-item d-flex align-items-center text-success">
                                                <i class="ti ti-check me-2 text-success"></i> Mark as Complete
                                            </a>
                                        @elseif($item->appointment_status == 'completed')
                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center disabled text-success" style="opacity: 0.5; pointer-events: none;">
                                                <i class="ti ti-check me-2 text-success"></i> Already Completed
                                            </a>
                                        @endif
                                    </li>
                                    <li>
                                        @if($item->appointment_status == 'online' || $item->appointment_status == 'offline')
                                            <a href="{{ route('doctor.appointments.update-status', ['id' => $item->id, 'status' => 'cancelled']) }}" class="dropdown-item d-flex align-items-center text-danger">
                                                <i class="ti ti-x me-2 text-danger"></i> Mark as Cancelled
                                            </a>
                                        @elseif($item->appointment_status == 'cancelled')
                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center disabled text-danger" style="opacity: 0.5; pointer-events: none;">
                                                <i class="ti ti-x me-2 text-danger"></i> Already Cancelled
                                            </a>
                                        @endif
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center view-appointment" data-id="{{ $item->id }}"
                                            data-bs-toggle="offcanvas" data-bs-target="#view_details"><i class="ti ti-eye me-2"></i>  View
                                        </a>
                                    </li>
                                    <li>
                                        <form method="POST" action="{{ route('doctor.appointments.destroy', $item->id) }}" class="delete-form d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="dropdown-item d-flex align-items-center text-danger confirm-delete"
                                                    data-doctor="{{ $item->doctor->name }}">
                                                <i class="ti ti-trash me-2"></i> Delete
                                            </button>
                                        </form>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <!--  End Table -->

        <!-- Start View Details -->
        <div class="offcanvas offcanvas-offset offcanvas-end" tabindex="-1" id="view_details">
            <div class="offcanvas-header d-block pb-0 px-0">
                <div class="border-bottom d-flex align-items-center justify-content-between pb-3 px-3">
                    <!-- Inside the Offcanvas -->
                    <h5 class="offcanvas-title fs-18 fw-bold">
                        Appointment Details <span class="badge badge-soft-primary border pt-1 px-2 border-primary fw-medium ms-2" id="view_appointment_id">#APT0000</span>
                    </h5>
                    <button type="button" class="btn-close custom-btn-close opacity-100" data-bs-dismiss="offcanvas" aria-label="Close"><i class="ti ti-x bg-white fs-16 text-dark"></i></button>            </div>
            </div>
            <div class="offcanvas-body pt-0 px-0">
                <h6 class="bg-light py-2 px-3 text-dark fw-bold"> When & Where </h6>
                <div class="px-3 my-4">
                    <!-- Example Data Section -->
                    <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> 
                        Appointment On <span class="text-body fw-normal" id="view_appointment_date">Loading...</span>
                    </p>
                    <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> 
                        Time <span class="text-body fw-normal" id="view_appointment_time">Loading...</span>
                    </p>
                    <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> 
                        Location <span class="text-body fw-normal" id="view_clinic">Loading...</span>
                    </p>
                    <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> 
                        Appointment Type <span class="text-body fw-normal" id="view_appointment_type">Loading...</span>
                    </p>
                    <!-- Patient Name -->
                    <div class="text-body fw-normal d-flex align-items-center" id="view_patient">
                        <span class="avatar avatar-sm me-1">
                            <img src="{{URL::asset('assets/img/PRED_CARE-Logo.png')}}" alt="" class="rounded-circle">
                        </span>
                        Loading...
                    </div>
                </div>
                <!-- <h6 class="bg-light py-2 px-3 text-dark fw-bold"> Appointment Details  </h6>
                <div class="px-3 my-4">
                    <!-- <div class="d-flex align-items-center justify-content-between mb-3">
                        <div class="d-flex align-items-center"> 
                            Telehealth 
                            <label class="d-flex align-items-center form-switch ps-1">
                                <input class="form-check-input m-0 me-2" type="checkbox" checked>
                            </label>
                        </div>
                        <div>  <a href="{{url('online-consulation')}}" class="btn-primary btn btn-sm rounded d-flex align-items-center"> <i class="ti ti-video me-1"></i> Start </a></div>
                    </div> --
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-6">
                            <p class="text-dark"> Status </p>
                        </div>
                        
                        <div class="col-lg-6 col-md-6"> 
                            <div class="mb-3">
                                <div class="dropdown">
                                    <a href="javascript:void(0);" class="dropdown-toggle form-control rounded d-flex align-items-center justify-content-between border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                        Pending
                                    </a>
                                    <div class="dropdown-menu shadow-lg w-100 dropdown-info">
                                        <div class="mb-3">
                                            <div class="input-icon-start position-relative">
                                                <span class="input-icon-addon fs-12">
                                                    <i class="ti ti-search"></i>
                                                </span>
                                                <input type="text" class="form-control form-control-sm" placeholder="Select">
                                            </div>
                                        </div>
                                        <ul class="mb-0 list-style-none">
                                            <li>
                                                <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                                    Checked Out
                                                </label>
                                            </li>
                                            <li>
                                                <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                    <input class="form-check-input m-0 me-2" type="checkbox" checked>
                                                    Checked In
                                                </label>
                                            </li>
                                            <li>
                                                <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                                    Cancelled
                                                </label>
                                            </li>
                                            <li>
                                                <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                                    Scheduled
                                                </label>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->

            </div>
        </div>
        <!-- End View Details -->
            
    </div>
    <!-- End Content -->
    
<!-- Delete Confirmation Modal -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".confirm-delete").forEach(function (button) {
            button.addEventListener("click", function () {
                const form = this.closest('form');
                const name = this.dataset.name || 'this appointment';

                Swal.fire({
                    title: 'Are you sure?',
                    text: `You are about to delete ${name}.`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Yes, delete it!',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });
        });
    });
</script>

<script>
// document.addEventListener('DOMContentLoaded', function () {
//     document.querySelectorAll('.view-appointment').forEach(function (el) {
//         el.addEventListener('click', function () {
//             const appointmentId = this.getAttribute('data-id');

//             fetch(`/appointments/${appointmentId}`)
//                 .then(response => response.json())
//                 .then(data => {
//                     document.getElementById('view_appointment_id').innerText = '#' + data.appointment_id;
//                     document.getElementById('view_appointment_date').innerText = data.appointment_date;
//                     document.getElementById('view_appointment_time').innerText = data.appointment_slot_time.join(' - ');
//                     document.getElementById('view_clinic').innerText = data.clinic_name || 'N/A';
//                     document.getElementById('view_appointment_type').innerText = data.appointment_type;
//                     document.getElementById('view_patient').innerHTML = `
//                         <span class="avatar avatar-sm me-1">
//                             <img src="${data.patient_image}" class="rounded-circle">
//                         </span>
//                         ${data.patient_name}
//                     `;
//                 });
//         });
//     });
// });
</script>


<script>
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".view-appointment").forEach(function (button) {
        button.addEventListener("click", function () {
            const id = this.dataset.id;

            // Laravel route helper with placeholder
            const url = '{{ route("doctor.appointments.show", ":id") }}'.replace(':id', encodeURIComponent(id));

            fetch(url)
                .then(response => response.json())
                .then(data => {
                    // Set values
                    document.getElementById('view_appointment_id').textContent = '#' + data.appointment_id;
                    document.getElementById('view_appointment_date').textContent = data.appointment_date;
                    document.getElementById('view_appointment_time').textContent = JSON.parse(data.appointment_slot_time).join(', ');
                    document.getElementById('view_clinic').textContent = data.clinic?.name || 'N/A';
                    document.getElementById('view_appointment_type').textContent = data.appointment_type.replace('_', ' ').toUpperCase();

                    const patientName = data.patient?.name || 'N/A';
                    document.getElementById('view_patient').innerHTML = `
                        <span class="avatar avatar-sm me-1">
                            <img src="/assets/img/PRED_CARE-Logo.png" alt="" class="rounded-circle">
                        </span>
                        ${patientName}
                    `;
                })
                .catch(error => {
                    console.error('Error fetching appointment:', error);
                });
        });
    });
});
</script>

@endsection

