@extends('layouts.app')

@section('title', 'Terms & Conditions')

@section('content')
<div class="content">
    <div class="row">
        <div class="col-12">
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">Edit Term & Condition</h6>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> Please fix the following issues:<br><br>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.terms.update', $term->id) }}" method="POST">
                @csrf

                <div class="card">
                    <div class="card-body pb-0">
                        <div id="doctor-form" class="form">

                            <div class="row">
                                <!-- terms -->
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label for="content" class="form-label mb-1 fw-medium">Edit Information on Terms & Conditions</label>
                                        <textarea name="content" id="content" rows="6" class="form-control" required>{{ old('content', $term->content) }}</textarea>
                                    </div>
                                    <div class="mb-3">
                                        <label for="status" class="form-label">Status</label>
                                        <select name="status" class="form-select" required>
                                            <option value="active" {{ $term->status === 'active' ? 'selected' : '' }}>Active</option>
                                            <option value="inactive" {{ $term->status === 'inactive' ? 'selected' : '' }}>Inactive</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="text-end">
                    <a href="{{ route('admin.patient-terms') }}" class="btn btn-warning"><i class="fas fa-times me-1"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Update Term</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection