<!-- resources/views/admin/doctors/form.blade.php -->
@extends('layouts.app')

@section('title', isset($editId) ? 'Edit Doctor' : 'Add Doctor')

@section('content')
    <div class="content">
        <!-- Page Header -->

        @if (session()->has('message'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('message') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if (session()->has('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @livewire('admin.doctor.doctor-form', ['editId' => $editId ?? null])

    </div>
@endsection

@push('scripts')
    {{-- <script>
    document.addEventListener('livewire:init', function() {
        // Initialize Select2 when Livewire is ready
        initializeSelect2();

        // Reinitialize Select2 after Livewire updates
        Livewire.hook('morph.updated', () => {
            initializeSelect2();
        });

        function initializeSelect2() {
            $('.select2').select2({
                placeholder: 'Select clinics',
                width: '100%'
            }).on('change', function(e) {
                const selectedValues = $(this).val() || [];
                @this.set('selected_clinics', selectedValues);
            });
        }
    });
</script> --}}
@endpush
