<?php

namespace Database\Seeders;

use App\Models\AddOn;
use App\Models\Feature;
use App\Models\PlanLimit;
use App\Models\UsageRate;
use App\Models\UsageType;
use App\Models\PlanFeature;
use App\Models\ComboPlanItem;
use Illuminate\Database\Seeder;
use App\Models\SubscriptionPlan;

class SubscriptionSetupSeeder extends Seeder
{
    public function run()
    {
        $storageType = UsageType::updateOrCreate(
            ['type_name' => 'Storage'],
            [
                'unit_name' => 'GB',
                'description' => 'Cloud storage capacity',
                'is_active' => true
            ]
        );

        $apiType = UsageType::updateOrCreate(
            ['type_name' => 'API Calls'],
            [
                'unit_name' => 'Calls',
                'description' => 'API request limits',
                'is_active' => true
            ]
        );

        $telemedType = UsageType::updateOrCreate(
            ['type_name' => 'Telemedicine'],
            [
                'unit_name' => 'Minutes',
                'description' => 'Video consultation minutes',
                'is_active' => true
            ]
        );

        $ehrFeature = Feature::updateOrCreate(
            ['feature_code' => 'EHR'],
            [
                'feature_name' => 'Electronic Health Records',
                'description' => 'Digital patient records system',
                'is_base_feature' => true,
                'feature_status' => 'active',
                'category' => 'Core'
            ]
        );

        $telemedFeature = Feature::updateOrCreate(
            ['feature_code' => 'TELEMED'],
            [
                'feature_name' => 'Telemedicine',
                'description' => 'Virtual consultations',
                'is_base_feature' => false,
                'feature_status' => 'active',
                'category' => 'Communication'
            ]
        );

        $analyticsFeature = Feature::updateOrCreate(
            ['feature_code' => 'ANALYTICS'],
            [
                'feature_name' => 'Advanced Analytics',
                'description' => 'Practice performance insights',
                'is_base_feature' => false,
                'feature_status' => 'active',
                'category' => 'Business'
            ]
        );

        $basicPlan = SubscriptionPlan::updateOrCreate(
            ['plan_code' => 'BASIC'],
            [
                'plan_name' => 'Basic Plan',
                'description' => 'For individual practitioners',
                'plan_type' => 'annual',
                'duration' => 1,
                'base_price' => 99.00,
                'discounted_price' => 89.00,
                'addon_eligible' => true,
                'is_combo' => false,
                'plan_status' => 'active',
                'max_doctors' => 3,
                'max_staff' => 5,
                'device_limit' => 2,
                'trial_period' => 14,
                'auto_renewal' => true,
                'currency' => 'USD'
            ]
        );

        $professionalPlan = SubscriptionPlan::updateOrCreate(
            ['plan_code' => 'PRO'],
            [
                'plan_name' => 'Professional Plan',
                'description' => 'For small to medium practices',
                'plan_type' => 'annual',
                'duration' => 1,
                'base_price' => 299.00,
                'discounted_price' => 249.00,
                'addon_eligible' => true,
                'is_combo' => false,
                'plan_status' => 'active',
                'max_doctors' => 10,
                'max_staff' => 5,
                'device_limit' => 5,
                'trial_period' => 7,
                'auto_renewal' => true,
                'currency' => 'USD'
            ]
        );

        $comboPlan = SubscriptionPlan::updateOrCreate(
            ['plan_code' => 'BASIC_PRO_COMBO'],
            [
                'plan_name' => 'Basic + Pro Combo',
                'description' => 'Bundled Basic and Professional Plans',
                'plan_type' => 'annual',
                'duration' => 1,
                'base_price' => 349.00,
                'discounted_price' => 249.00,
                'addon_eligible' => false,
                'is_combo' => true,
                'plan_status' => 'active',
                'currency' => 'USD',
                'max_doctors' => 0,
                'max_staff' => 5,
                'device_limit' => 0,
                'trial_period' => 0,
                'auto_renewal' => true
            ]
        );

        ComboPlanItem::updateOrCreate(
            ['combo_plan_id' => $comboPlan->id, 'item_type' => 'plan', 'item_id' => $basicPlan->id],
            ['quantity' => 1]
        );

        PlanLimit::updateOrCreate(
            ['plan_id' => $basicPlan->id],
            [
                'included_doctors' => 3,
                'included_staff' => 5,
                'storage_limit_gb' => 100,
                'teleconsultation_minutes' => 300,
                'sms_limit' => 100,
                'whatsapp_limit' => 50,
                'additional_doctor_price' => 79.00,
                'additional_staff_price' => 29.00
            ]
        );

        PlanLimit::updateOrCreate(
            ['plan_id' => $professionalPlan->id],
            [
                'included_doctors' => 3,
                'included_staff' => 7,
                'storage_limit_gb' => 500,
                'teleconsultation_minutes' => 1000,
                'sms_limit' => 500,
                'whatsapp_limit' => 200,
                'additional_doctor_price' => 69.00,
                'additional_staff_price' => 19.00
            ]
        );

        PlanLimit::updateOrCreate(
            ['plan_id' => $comboPlan->id],
            [
                'included_doctors' => 6,
                'included_staff' => 12,
                'storage_limit_gb' => 600,
                'teleconsultation_minutes' => 1300,
                'sms_limit' => 600,
                'whatsapp_limit' => 250,
                'additional_doctor_price' => 69.00,
                'additional_staff_price' => 19.00
            ]
        );

        PlanFeature::updateOrCreate(
            ['plan_id' => $basicPlan->id, 'feature_id' => $ehrFeature->id],
            ['included' => true]
        );

        PlanFeature::updateOrCreate(
            ['plan_id' => $professionalPlan->id, 'feature_id' => $ehrFeature->id],
            ['included' => true]
        );

        PlanFeature::updateOrCreate(
            ['plan_id' => $professionalPlan->id, 'feature_id' => $telemedFeature->id],
            ['included' => true]
        );

        UsageRate::updateOrCreate(
            ['plan_id' => $basicPlan->id, 'usage_type_id' => $storageType->id],
            [
                'rate_per_unit' => 0.10,
                'free_units' => 100,
                'overage_rate' => 150,
                'currency' => 'USD',
                'effective_date' => now()
            ]
        );

        $storageAddon = AddOn::updateOrCreate(
            ['addon_code' => 'STORAGE_100'],
            [
                'name' => '+100GB Storage',
                'resource_type' => 'storage',
                'unit' => 'GB',
                'unit_counts' => 100,
                'price_per_unit' => 1.99,
                'billing_cycle' => 'monthly',
                'is_active' => true
            ]
        );

        // 3. Telecommunication Service
        $taleAddOn = AddOn::updateOrCreate(
            ['addon_code' => 'TELECOM'],
            [
                'name' => '+1000 minutes Teleconsultation',
                'resource_type' => 'talecommunication',
                'unit' => 'Minute',
                'unit_counts' => 1000,
                'price_per_unit' => 0.3, // $0.05 per minute
                'billing_cycle' => 'monthly',
                'is_active' => true
            ]
        );

        // 4. SMS Service
        AddOn::updateOrCreate(
            ['addon_code' => 'SMS'],
            [
                'name' => '+1000 SMS Service',
                'resource_type' => 'sms',
                'unit' => 'Message',
                'unit_counts' => 1000,
                'price_per_unit' => 0.02, // $0.02 per SMS
                'billing_cycle' => 'monthly',
                'is_active' => true
            ]
        );

        // 5. WhatsApp Service
        AddOn::updateOrCreate(
            ['addon_code' => 'WHATSAPP'],
            [
                'name' => '+1000 WhatsApp Business Service',
                'resource_type' => 'whatsapp',
                'unit' => 'Message',
                'unit_counts' => 1000,
                'price_per_unit' => 0.03, // $0.03 per WhatsApp message
                'billing_cycle' => 'monthly',
                'is_active' => true
            ]
        );

        ComboPlanItem::updateOrCreate(
            ['combo_plan_id' => $comboPlan->id, 'item_type' => 'addon', 'item_id' => $storageAddon->id],
            ['quantity' => 1]
        );

        ComboPlanItem::updateOrCreate(
            ['combo_plan_id' => $comboPlan->id, 'item_type' => 'addon', 'item_id' => $taleAddOn->id],
            ['quantity' => 1]
        );
    }
}
