<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('support_tickets', function (Blueprint $table) {
            $table->id();
            $table->string('ticket_no')->unique();

            // Relations
            $table->unsignedBigInteger('patient_id')->nullable();
            $table->unsignedBigInteger('doctor_id')->nullable();
            $table->unsignedBigInteger('created_by'); // jisne ticket banaya (doctor/patient/admin)
            $table->enum('created_by_type', ['doctor', 'patient', 'admin']);

            // Ticket info
            $table->string('email');
            $table->string('subject');
            $table->text('message');
            $table->enum('status', ['open', 'in_progress', 'closed'])->default('open')->nullable(false);
            $table->timestamps();

            // Optional foreign keys (अगर users table से relation चाहिए तो uncomment करें)
            // $table->foreign('patient_id')->references('id')->on('users')->onDelete('set null');
            // $table->foreign('doctor_id')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('support_tickets');
    }
};
