<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('customer_subscriptions', function (Blueprint $table) {

            if (!Schema::hasColumn('customer_subscriptions', 'clinic_id')) {
                $table->unsignedBigInteger('clinic_id')->nullable()->after('plan_id');
            }
            $table->foreign('clinic_id')
                  ->references('id')
                  ->on('clinics')
                  ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('customer_subscriptions', function (Blueprint $table) {
            $table->dropForeign(['clinic_id']);
        });
    }
};