<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('system_resource_pools', function (Blueprint $table) {
            $table->id();
            $table->foreignId('usage_type_id')->constrained('usage_types')->unique();
            $table->unsignedBigInteger('total_available')->default(0);
            $table->unsignedBigInteger('allocated')->default(0);
            $table->unsignedBigInteger('reserved')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('system_resource_pools');
    }
};
