<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('active_devices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            // New fields for role-based tracking
            $table->enum('role_type', [
                'superadmin',
                'superadminstaff',
                'doctor',
                'doctor_staff',
                'primary_doctor',
                'sub_doctor',
                'staff',
                'patient'
            ])->default('staff');

            $table->foreignId('clinic_id')->nullable();

            $table->string('device_id', 255);
            $table->string('session_id', 250)->nullable();
            $table->string('device_name', 255)->nullable();
            $table->enum('platform', ['android', 'ios', 'web', 'desktop']);
            $table->string('os_version', 50)->nullable();
            $table->string('app_version', 50)->nullable();
            $table->string('ip_address', 45)->nullable();
            $table->enum('login_method', ['phone', 'email']);
            $table->timestamp('last_active_at')->useCurrent()->useCurrentOnUpdate();
            $table->timestamp('login_at')->useCurrent();
            $table->string('fcm_token', 255)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamp('logout_at')->nullable();
            $table->timestamps();

            // Updated indexes
            $table->unique(['user_id', 'device_id']);
            $table->index(['user_id', 'role_type', 'clinic_id', 'is_active'], 'idx_role_sessions');
            $table->index(['user_id', 'is_active', 'last_active_at'], 'idx_active_sessions');
            $table->index(['fcm_token'], 'idx_fcm_tokens');
        });
    }

    public function down()
    {
        Schema::dropIfExists('active_devices');
    }
};