<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('credit_transactions', function (Blueprint $table) {
            $table->id(); 
            $table->unsignedBigInteger('subscription_id');
            $table->decimal('amount', 10, 2);
            $table->string('transaction_type', 20);
            $table->string('reference_id', 50);
            $table->decimal('balance_after', 10, 2);
            $table->dateTime('transaction_date');
            $table->text('notes')->nullable();
            $table->string('payment_method', 50)->nullable();
            $table->timestamps();
            
            $table->foreign('subscription_id')->references('id')->on('customer_subscriptions');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('credit_transactions');
    }
};
