<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('usage_rates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plan_id')->constrained('subscription_plans');
            $table->foreignId('usage_type_id')->constrained('usage_types');
            $table->decimal('rate_per_unit', 10, 2);
            $table->unsignedInteger('free_units')->default(0);
            $table->decimal('overage_rate', 10, 2)->nullable();
            $table->string('currency', 3)->default('INR');
            $table->dateTime('effective_date');
            $table->dateTime('expiry_date')->nullable();
            $table->timestamps();
        
            $table->unique(['plan_id', 'usage_type_id', 'effective_date']);
            $table->index(['usage_type_id', 'effective_date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('usage_rates');
    }
};
