<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('usage_types', function (Blueprint $table) {
            $table->id();
            $table->string('type_name', 50)->unique(); 
            $table->string('unit_name', 20); 
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_billable')->default(true);
            $table->string('category', 30)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('usage_types');
    }
};
