<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserProfile extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'full_name',
        'first_name',
        'last_name',
        'alternate_phone',
        'gender',
        'date_of_birth',
        'profile_picture',
        'language_preferences',
        'timezone',
    ];

    protected $casts = [
        'language_preferences' => 'array',
        'date_of_birth' => 'date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}