<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\{
    HasOne,
    HasMany
};

class SubscriptionPlan extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'plan_code',
        'plan_name',
        'description',
        'plan_type',
        'duration',
        'base_price',
        'discounted_price',
        'addon_eligible',
        'is_combo',
        'plan_status',
        'max_doctors',
        'max_staff',
        'device_limit',
        'trial_period',
        'auto_renewal',
        'currency'
    ];

    public function limit(): HasOne
    {
        return $this->hasOne(PlanLimit::class, 'plan_id');
    }

    public function features(): HasMany
    {
        return $this->hasMany(PlanFeature::class, 'plan_id');
    }

    public function usageRates(): HasMany
    {
        return $this->hasMany(UsageRate::class, 'plan_id');
    }
    public function comboItems()
    {
        return $this->hasMany(ComboPlanItem::class, 'combo_plan_id');
    }

    public function isCombo()
    {
        return $this->is_combo;
    }

}