<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StaffClinic extends Model
{
    use HasFactory;

    protected $fillable = [
        'staff_id',
        'clinic_id',
        'doctor_id',
        'added_by',
        'status',
        'approval_status',
        'approved_at',
        'permissions'
    ];

    protected $casts = [
        'permissions' => 'array',
        'approved_at' => 'datetime',
    ];

    public function staff()
    {
        return $this->belongsTo(User::class, 'staff_id');
    }

    public function clinic()
    {
        return $this->belongsTo(Clinic::class);
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id');
    }

    public function addedBy()
    {
        return $this->belongsTo(User::class, 'added_by');
    }
}