<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Staff extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'phone',
        'profile_image',
        'position',
        'qualifications',
        'status'
    ];

    protected $casts = [
        'status' => 'string',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function clinics()
    {
        return $this->belongsToMany(Clinic::class, 'staff_clinics')
                    ->withPivot(['doctor_id', 'is_primary', 'status', 'notes'])
                    ->withTimestamps();
    }
}