<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PatientClinic extends Model
{
    use HasFactory;

    protected $table = 'patient_clinics';

    protected $fillable = [
        'patient_id',
        'clinic_id',
        'doctor_id',
        'added_by',
        'status',
        'approval_status',
        'approved_at',
        'notes'
    ];

    protected $casts = [
        'notes' => 'array',
        'approved_at' => 'datetime',
    ];

    public function patient()
    {
        return $this->belongsTo(User::class, 'patient_id');
    }

    public function clinic()
    {
        return $this->belongsTo(Clinic::class, 'clinic_id');
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id');
    }

    public function addedBy()
    {
        return $this->belongsTo(User::class, 'added_by');
    }
}