<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DoctorSubscriptionMember extends Model
{
    protected $fillable = [
        'subscription_id', 'doctor_id',
        'approval_status', 'approved_at', 'approved_by'
    ];

    protected $dates = ['approved_at'];

    public function subscription()
    {
        return $this->belongsTo(CustomerSubscription::class);
    }

    public function doctor()
    {
        return $this->belongsTo(User::class);
    }

    public function limits()
    {
        return $this->hasMany(DoctorSubscriptionLimit::class, 'member_id');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function getLimit($usageTypeName)
    {
        return $this->limits()
            ->whereHas('usageType', fn($q) => $q->where('type_name', $usageTypeName))
            ->first();
    }

    public function clinicAssociations()
    {
        return $this->hasMany(DoctorClinic::class, 'subscription_member_id');
    }
}