<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DoctorSubscriptionLimit extends Model
{
    protected $fillable = [
        'member_id', 'usage_type_id', 'allocated',
        'used', 'reserved', 'uses_shared_pool',
        'allow_overage', 'overage_rate_multiplier'
    ];

    protected $casts = [
        'uses_shared_pool' => 'boolean',
        'allow_overage' => 'boolean'
    ];

    public function member()
    {
        return $this->belongsTo(DoctorSubscriptionMember::class, 'member_id');
    }

    public function usageType()
    {
        return $this->belongsTo(UsageType::class);
    }

    public function remaining()
    {
        return $this->allocated - $this->used;
    }

    public function available()
    {
        return $this->allocated - ($this->used + $this->reserved);
    }
}