<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DoctorAvailability extends Model
{
    use HasFactory;

    protected $table = 'doctor_availability';

    protected $fillable = [
        'clinic_id',
        'doctor_id',
        'slot_duration',
        'day',
        'from_time',
        'to_time',
        'time_slot',
        'booked_time_slot',
        'in_person_fee',
        'video_fee',
        'status',
        'other',
    ];

    protected $casts = [
        'time_slot' => 'array',
        'booked_time_slot' => 'array',
        'from_time' => 'datetime:H:i',
        'to_time' => 'datetime:H:i',
        'status' => 'boolean',
    ];

    // Relationships (optional)
    public function clinic()
    {
        return $this->belongsTo(Clinic::class);
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id');
    }
}
