<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CreditTransaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'subscription_id',
        'amount',
        'transaction_type',
        'reference_id',
        'balance_after',
        'transaction_date',
        'notes',
        'payment_method'
    ];

    public function subscription()
    {
        return $this->belongsTo(CustomerSubscription::class);
    }
}