<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ActiveDevice extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'clinic_id',
        'device_id',
        'session_id',
        'device_name',
        'platform',
        'os_version',
        'app_version',
        'ip_address',
        'login_method',
        'last_active_at',
        'login_at',
        'fcm_token',
        'is_active',
        'role_type',
        'logout_at',
    ];

    protected $casts = [
        'last_active_at' => 'datetime',
        'login_at' => 'datetime',
        'is_active' => 'boolean',
        'logout_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function clinic()
    {
        return $this->belongsTo(Clinic::class);
    }
    public function getMaxDevicesAttribute(): int
    {
        if ($this->role_type === 'superadmin') {
            return PHP_INT_MAX;
        }

        if ($this->role_type === 'primary_doctor' || $this->role_type === 'sub_doctor') {
            $doctorClinic = DoctorClinic::where('doctor_id', $this->user_id)
                ->where('clinic_id', $this->clinic_id)
                ->first();

            if ($doctorClinic && $doctorClinic->device_limit) {
                return $doctorClinic->device_limit;
            }
        }
        return $this->user->device_limit_override ?? $this->user->max_active_devices;
    }

    public function isCurrentDevice(): bool
    {
        return $this->device_id === session('device_id');
    }
}