<?php
namespace App\Mail\Staff;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UpdateStaffMail extends Mailable
{
    use Queueable, SerializesModels;

    public $staffName;
    public $clinicName;
    public $ownerName;
    public $role;
    public $accessLevel;
    public $assignedDoctor;
    public $updatedModules;

    public function __construct(
        string $staffName,
        string $clinicName,
        string $ownerName,
        string $role,
        string $accessLevel,
        ?string $assignedDoctor,
        array $updatedModules = []
    ) {
        $this->staffName = $staffName;
        $this->clinicName = $clinicName;
        $this->ownerName = $ownerName;
        $this->role = $role;
        $this->accessLevel = $accessLevel;
        $this->assignedDoctor = $assignedDoctor;
        $this->updatedModules = $updatedModules;
    }

    public function build()
    {
        return $this->subject('Staff Account Update Notification – PRED Care')
            ->view('mail.staff.update-staff-mail');
    }
}