<?php

namespace App\Mail\Patient;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\User;
use App\Models\Patient;

class CreatePatientMail extends Mailable
{
    use Queueable, SerializesModels;

    public $adminDoctor;
    public $patient;
    public $createdBy;
    public $createdAt;

    /**
     * Create a new message instance.
     */
    public function __construct(User $adminDoctor, Patient $patient, User $createdBy, $createdAt)
    {
        $this->adminDoctor = $adminDoctor;
        $this->patient = $patient;
        $this->createdBy = $createdBy;
        $this->createdAt = $createdAt;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'New Patient Profile Created on PRED Care',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'mail.patient.create-patient-mail',
            with: [
                'adminDoctor' => $this->adminDoctor,
                'patient' => $this->patient,
                'createdBy' => $this->createdBy,
                'createdAt' => $this->createdAt,
            ]
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}