<?php

namespace App\Livewire\Doctor\Profile;

use Livewire\Component;
use App\Models\DoctorProfile;
use Illuminate\Support\Facades\Auth;

class DoctorAboutComponent extends Component
{
    public $doctor;
    public $educations;
    public $experiences;
    public $uploadedCertificates;

    public function mount()
    {
        $this->doctor = Auth::user()->doctorProfile;
        $this->educations = $this->doctor->educations ?? [];
        $this->experiences = $this->doctor->experiences ?? [];
        $this->uploadedCertificates = json_decode($this->doctor?->certificates , true) ?? [];
    }

    public function getInitials($name)
    {
        if (empty($name)) {
            return 'NA';
        }

        $words = explode(' ', trim($name));

        if (count($words) >= 2) {
            return strtoupper(substr($words[0], 0, 1) . substr($words[count($words) - 1], 0, 1));
        } else {
            return strtoupper(substr($name, 0, 2));
        }
    }

    public function getAvatarColorClass($name)
    {
        $colors = ['bg-primary', 'bg-success', 'bg-info', 'bg-warning', 'bg-danger', 'bg-secondary'];
        $hash = crc32($name);
        return $colors[abs($hash) % count($colors)];
    }

    public function render()
    {
        return view('livewire.doctor.profile.doctor-about-component');
    }
}