<?php

// namespace App\Livewire\Doctor\Doctor;

// use App\Models\User;
// use Livewire\Component;
// use Illuminate\Support\Facades\Log;
// use Illuminate\Support\Facades\Gate;
// use Illuminate\Support\Facades\DB;

// class DoctorView extends Component
// {
//     public $doctor;
//     public $educations;
//     public $experiences;
//     public $clinics;
//     public $primaryClinic;
//     public $certificates;
//     public $availabilities; // doctor_availability data store karne ke liye

//     public function mount($id)
//     {
//         Gate::authorize('view doctor profile');

//         $this->doctor = User::with([
//             'doctor',
//             'clinics' => function ($query) {
//                 $query->withPivot([
//                     'is_primary',
//                     'status',
//                     'approval_status',
//                     'approved_at',
//                     'in_person_fee',
//                     'video_fee',
//                     'home_visit_fee',
//                     'in_person_duration',
//                     'video_duration',
//                     'home_visit_duration',
//                     'offers_in_person',
//                     'offers_video',
//                     'offers_home_visit'
//                 ]);
//             },
//             'primaryClinics'
//         ])->findOrFail($id);

//         $this->educations = $this->doctor->doctorProfile->educations ?? collect();
//         $this->experiences = $this->doctor->doctorProfile->experiences ?? collect();
//         $this->certificates = json_decode($this->doctor->doctorProfile->certificates) ?? collect();
//         $this->clinics = $this->doctor->clinics ?? collect();
//         $this->primaryClinic = $this->doctor->primaryClinics->first();

//         // Fetch doctor_availability table data for this doctor
//         $this->availabilities = DB::table('doctor_availability')
//             ->where('doctor_id', $id)
//             ->get();
//         Log::info('Doctor availability:', $this->availabilities->toArray());

//         //dd($this->certificates);
//         Log::info('Doctor data:', $this->doctor->toArray());
//     }

//     public function render()
//     {
//         return view('livewire.doctor.doctor.doctor-view');
//     }
// }

namespace App\Livewire\Doctor\Doctor;

use App\Models\User;
use Livewire\Component;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;

class DoctorView extends Component
{
    public $doctor;
    public $educations;
    public $experiences;
    public $clinics;
    public $primaryClinic;
    public $certificates;
    public $availabilities; 
    public $patients;       // 👈 new
    public $staff;          // 👈 new

    public function mount($id)
    {
        Gate::authorize('view doctor profile');

        // Doctor basic + clinics
        $this->doctor = User::with([
            'doctor',
            'doctorProfile',
            'clinics' => function ($query) {
                $query->withPivot([
                    'is_primary',
                    'status',
                    'approval_status',
                    'approved_at',
                    'in_person_fee',
                    'video_fee',
                    'home_visit_fee',
                    'in_person_duration',
                    'video_duration',
                    'home_visit_duration',
                    'offers_in_person',
                    'offers_video',
                    'offers_home_visit'
                ]);
            },
            'primaryClinics'
        ])->findOrFail($id);

        $this->educations   = $this->doctor->doctorProfile->educations ?? collect();
        $this->experiences  = $this->doctor->doctorProfile->experiences ?? collect();
        $this->certificates = json_decode($this->doctor->doctorProfile->certificates) ?? collect();
        $this->clinics      = $this->doctor->clinics ?? collect();
        $this->primaryClinic = $this->doctor->primaryClinics->first();

        // Doctor availability
        $this->availabilities = DB::table('doctor_availability')
            ->where('doctor_id', $id)
            ->get();

        // Patients assigned via patient_clinics
        $this->patients = DB::table('patient_clinics as pc')
            ->join('users as u', 'u.id', '=', 'pc.patient_id')
            ->where('pc.doctor_id', $id)
            ->select(
                'pc.id',
                'u.name',
                'u.email',
                'pc.status',
                'pc.approval_status',
                'pc.clinic_id',
                'pc.created_at',
                'pc.updated_at'
            )
            ->get();

        // Staff assigned via staff_clinics
        $this->staff = DB::table('staff_clinics as sc')
            ->join('users as u', 'u.id', '=', 'sc.staff_id')
            ->where('sc.doctor_id', $id)
            ->select(
                'sc.id',
                'u.name',
                'u.email',
                'sc.status',
                'sc.approval_status',
                'sc.clinic_id',
                'sc.created_at',
                'sc.updated_at'
            )
            ->get();

        Log::info('Doctor availability:', $this->availabilities->toArray());
        Log::info('Doctor patients:', $this->patients->toArray());
        Log::info('Doctor staff:', $this->staff->toArray());
        Log::info('Doctor data:', $this->doctor->toArray());
    }

    public function render()
    {
        return view('livewire.doctor.doctor.doctor-view');
    }
}
