<?php

namespace App\Livewire\Admin\SubscriptionPlanWizard;

use Livewire\Component;
use App\Models\Feature;
use App\Models\UsageType;
use App\Models\SubscriptionPlan;
use App\Models\AddOn;

class Step5Review extends Component
{
    public $planData;
    public $available_features;
    public $available_usage_types;
    public $isEditing;
    public $selected_plan_id = null;
    public $selected_add_on_id = [];
    public $showPlanSelection;
    public $showAddOnSelection;
    public $availablePlans;
    public $availableAddOns;
    public $showPlanSection = false;
    public $showAddOnSection = false;
    public $selectedPlanDetails = null;
    public $selectedPlanLimits = null;
    public $selectedAddOnDetails = [];
    public $editingDoctor = false;

    public function mount($planData, $isEditing = false)
    {
        $this->planData = $planData;
        $this->isEditing = $isEditing;

        // Validate we have all required data
        $this->validateData();

        $this->available_features = Feature::whereIn('id', $planData['features'] ?? [])->get();
        $this->available_usage_types = UsageType::all()->keyBy('id');
        $this->availablePlans = SubscriptionPlan::where('plan_status', 'active')->get();
        $this->availableAddOns = AddOn::where('is_active', true)->get();

        if (!empty($planData['basic']['is_combo']) && !empty($planData['is_combo'])) {
            // Set the selected plan ID and details
            $this->selected_plan_id = $planData['is_combo']['plan'];

            // Load the selected plan details if plan ID exists
            if ($this->selected_plan_id) {
                $this->selectedPlanDetails = SubscriptionPlan::find($this->selected_plan_id);
                $this->selectedPlanLimits = $this->selectedPlanDetails->limit ?? null;
            }

            // Set selected addons and load their details
            $this->selected_add_on_id = $planData['is_combo']['addon'] ?? [];

            if (!empty($this->selected_add_on_id)) {
                $this->selectedAddOnDetails = AddOn::whereIn('id', $this->selected_add_on_id)->get();
            } else {
                $this->selectedAddOnDetails = [];
            }
        }
    }

    protected function validateData()
    {
        // Add validation rules for complete plan data
        if (
            empty($this->planData['basic']) ||
            empty($this->planData['limits']) ||
            empty($this->planData['features'])
        ) {
            session()->flash('error', 'Missing required plan data');
            if (empty($this->planData['basic'])) {
                notyf()->error('Missing Basic plan data');
            } elseif (empty($this->planData['limits'])) {
                notyf()->error('Missing Limits of plan data');
            } elseif (empty($this->planData['features'])) {
                notyf()->error('Missing Features for plan data');
            } else {
                notyf()->error('Missing required plan data');
            }
            $this->dispatch('goToStep', step: 1);
        }
    }


    public function previous()
    {
        $this->dispatch('goToStep', step: 4);
    }

    public function submit()
    {
        $this->dispatch(
            'updatePlanData',
            step: 'is_combo',
            data: [
                'plan' => $this->selected_plan_id,
                'addon' => $this->selected_add_on_id,
            ]
        );
        $this->dispatch('savePlan');
    }

    public function togglePlanSelection()
    {
        $this->showPlanSelection = !$this->showPlanSelection;

        if ($this->selected_plan_id) {
            $this->selectedPlanDetails = SubscriptionPlan::find($this->selected_plan_id);
            $this->selectedPlanLimits = $this->selectedPlanDetails->limit;
        }
    }
    public function toggleAddOnSelection()
    {
        $this->showAddOnSelection = !$this->showAddOnSelection;

        if ($this->selected_add_on_id) {
            foreach ($this->selected_add_on_id as $index => $addOnId) {
                $this->selectedAddOnDetails[$index] = AddOn::find($addOnId);
            }
        } else {
            $this->selectedAddOnDetails = null;
        }
    }
    public function updatedSelectedPlanId($value)
    {
        if ($value) {
            $this->selectedPlanDetails = SubscriptionPlan::find($value);
            $this->showPlanSelection = false;
            $this->selectedPlanLimits = $this->selectedPlanDetails->limit;
        } else {
            $this->selectedPlanDetails = null;
        }
    }
    public function updateSelectedCount()
    {
        // Just forces a UI refresh
        $this->dispatch('addons-updated');
    }


    public function render()
    {
        return view('livewire.admin.subscription-plan-wizard.step5-review');
    }
}
